import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * This class implements some of the more complicated functionality of the ship, and is provided complete.
 * It does not need to be modified.
 * 
 * @author Michael Berry
 * @version 21/03/2008
 */
public abstract class MotherShip extends Actor
{

    private AlienWorld world;
    private final int DELAY = 60;
    private int delayCounter;
    
    /**
     * Move the ship left
     */
    public void moveLeft()
    {
        setLocation(getX()-2, getY());
    }
    
    /**
     * Move the ship right
     */
    public void moveRight()
    {
        setLocation(getX()+2, getY());
    }
    
    /**
     * Returns whether a shot should be fired.
     * @return true if a shot needs to be fired.
     */
    public boolean shotKey()
    {
        return (Greenfoot.isKeyDown("up") || Greenfoot.isKeyDown("space")) && delayCounter==0;
    }
    
    /**
     * Fires a shot
     */
    public void fire()
    {
        world.addObject(new Shot(true), getX(), getY()- (getImage().getHeight())/2);
        delayCounter = DELAY;
    }
    
    /**
     * Returns whether the ship is shot
     * @return True if the ship has been shot
     */
    public boolean isShot()
    {
        Shot shot;
        boolean r = (shot = (Shot)getOneIntersectingObject(Shot.class)) != null && !shot.getDirection();
        if(r) world.removeObject(shot);
        return r;
    }
    
    /**
     * Updates the score. Calls the update method of score.
     */
    public void updateScore(int x)
    {
        world.updateScore(x);
    }
    
    /**
     * Act - do whatever the Ship wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        if(delayCounter > 0) delayCounter--;
    }
    
    /**
     * Called when the object is added into the world, you can safely ignore this method.
     */
    public void addedToWorld(World world)
    {
        this.world = (AlienWorld)world;
        delayCounter = 0;
        setImage("images/rocket.png");
    }
}
