import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Either kills aliens or lowers your score, depending on how lucky you are...
 * 
 * @author Michael Berry
 * @version 28/03/2008
 */
public class Shot extends Actor
{

    private AlienWorld world;
    private boolean direction;
    
    public Shot(boolean direction)
    {
        this.direction = direction;
    }
    
    /**
     * Act - do whatever the Shot wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        if(direction) setLocation(getX(), getY()-2);
        else setLocation(getX(), getY()+2);
        if(getY()<10 || getY()>world.getHeight()-10) world.removeObject(this);
    }
    
    /**
     * Called when the object is added into the world, you can safely ignore this method.
     */
    public void addedToWorld(World world)
    {
        this.world = (AlienWorld)world;
        setImage("images/shot.bmp");
    }
    
    /**
     * Returns the direction of the shot.
     */
    public boolean getDirection()
    {
        return direction;
    }
}
