/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green;

import edu.buffalo.cse.green.JavaModelListener;
import edu.buffalo.cse.green.RefactorHandler;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompilationUnitRefactorHandler<E extends ICompilationUnit>
implements RefactorHandler<E> {
    private static final CompilationUnitRefactorHandler<ICompilationUnit> INSTANCE = new CompilationUnitRefactorHandler();

    CompilationUnitRefactorHandler() {
    }

    public static CompilationUnitRefactorHandler<ICompilationUnit> instance() {
        return INSTANCE;
    }

    @Override
    public void handleAdd(RootModel root, E element) {
    }

    @Override
    public void handleMove(RootModel root, E sourceElement, E targetElement) {
        String scuId = sourceElement.getHandleIdentifier();
        String tcuId = targetElement.getHandleIdentifier();
        String scuName = scuId.substring(scuId.indexOf(123) + 1, scuId.indexOf(".java"));
        String tcuName = tcuId.substring(tcuId.indexOf(123) + 1, tcuId.indexOf(".java"));
        List<IJavaElement> cuTypes = root.getElementsOfKind(7);
        for (IJavaElement oType : cuTypes) {
            if (!JavaModelListener.sameElements(sourceElement, oType.getAncestor(5))) continue;
            String oId = oType.getHandleIdentifier();
            String oName = oId.substring(oId.indexOf(91));
            oName = oName.replaceAll("\\[" + scuName, "[" + tcuName);
            IJavaElement nType = JavaCore.create((String)(String.valueOf(tcuId) + oName));
            TypeModel oModel = (TypeModel)root.getModelFromElement(oType);
            oModel.removeFromParent();
            TypeModel nModel = root.createTypeModel((IType)nType);
            nModel.setLocation(oModel.getLocation());
            nModel.setSize(oModel.getSize());
        }
    }

    @Override
    public void handleRemove(RootModel root, E element) {
        if (element.isWorkingCopy()) {
            return;
        }
        ArrayList<IJavaElement> types = new ArrayList<IJavaElement>(root.getElementsOfKind(7));
        for (IJavaElement type : types) {
            if (!JavaModelListener.sameElements(element, type.getAncestor(5)) || root.getModelFromElement(type) == null) continue;
            root.getModelFromElement(type).removeFromParent();
        }
    }
}

