/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green;

import edu.buffalo.cse.green.GreenFileException;
import edu.buffalo.cse.green.IllegalOperationException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.types.ITypeProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenException
extends RuntimeException {
    protected static final long serialVersionUID = -760398655607581288L;
    public static final String GRERR_JVM_CHANGE_UNHANDLED = "Unhandled JavaModel change";
    public static final String GRERR_INVALID_INDEX = "Invalid index";
    public static final String GRERR_FILE_FORMAT = "Invalid file format";
    public static final String GRERR_FILE_NOT_FOUND = "Unable to find specified file";
    public static final String GRERR_INVALID_RELATIONSHIP_NODES = "Invalid source or target node for relationship";
    public static final String GRERR_PALETTE_CREATION = "Unsupported creation";
    public static final String GRERR_RELATIONSHIP_NO_METHODS = "No methods exist in the given source class";
    public static final String GRERR_DUPLICATE_EXTENSION = "Duplicate Green file extension detected. Check you plugin.xml files.";
    public static final String GRERR_EMPTY_PROJECT = "Cannot use an empty project";
    public static final String GRERR_UNHANDLED_JAVA_TYPE = "The given type is unsupported for the current operation";
    public static final String GRERR_USING_DEFAULT_PACKAGE = "Cannot use default package in editor for type";
    public static final String GRWARN_ELEMENT_IN_WRONG_EDITOR = "Element added to wrong editor";
    public static final String GRERR_WRONG_SOURCE_PROJECT = "The editor whose project was reset did not have the specified old project";
    public static final String GRERR_INVALID_XML_STRUCTURE = "The structure of the DIA file cannot be interpretted by the plugin.";
    public static final String GRERR_FILE_VERSION_TITLE = "File newer than plugin.";
    public static final String GRERR_NULL = "Argument is null.";
    public static final String GRERR_TYPE_UNSUPPORTED = "Type is Unsupported.";
    public static final String GRERR_FIGURE_CONSTRUCTOR = "Wrong number of constructors or parameters. The class must have one constructor with no parameters.";
    public static final String UNSUPPORTED_FILE_VERSION = "The version of the file you are trying to load in is unsupported: ";
    private static final String GRERR_REPORT_CRITICAL = "A critical error has occurred. You should copy this message along with the stack trace below and send it to the contact address provided with this software.";
    public static final String GRERR_INVALID_CONTEXT_ACTION = "Action class must be a subclass of ContextAction";
    public static final String GRERR_INVALID_EXTENSION = "Invalid extension. Valid extensions must consist of alphanumeric characters and must be between 1 and 4 characters in length.";
    public static final String GRERR_REL_SOURCE_BINARY = "A relationship cannot be generated with a binary type as its source.";
    public static final String GRERR_UNAVAILABLE_ACTION = "The desired action is not currently available";

    public GreenException(String description) {
        super(description);
    }

    public static void warn(String message) {
        System.err.println("WARNING: " + message);
    }

    public static String generateVersionWarning(int pluginVersion, int fileVersion) {
        return "The file you are trying to load was made with a newer version of Green (" + fileVersion + ") than you are currently running (" + pluginVersion + "). You should install an updated version of Green. " + "The contents of the editor may not accurately reflect the appearance" + " of the diagram when it was last saved. If you save this diagram in " + "the editor, some information from the diagram file may be lost.";
    }

    public static void critical(Throwable t) {
        GreenException.warn(GRERR_REPORT_CRITICAL);
        t.printStackTrace();
    }

    public static void illegalOperation() {
        throw new IllegalOperationException("no message specified");
    }

    public static void illegalOperation(String description) {
        if (description == null) {
            return;
        }
        throw new IllegalOperationException(description);
    }

    public static void fileException(String description) {
        throw new GreenFileException(description);
    }

    public static void errorDialog(String error) {
        MessageDialog.openInformation((Shell)PlugIn.getDefaultShell(), (String)"Error", (String)error);
    }

    public static void illegalExtensionClass(Class<? extends Object> aClass, Class<ITypeProperties> eClass) {
        GreenException.illegalOperation("Illegal plugin class: expected " + eClass + ", but " + "was " + aClass);
    }
}

