/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green;

import edu.buffalo.cse.green.JavaModelListener;
import edu.buffalo.cse.green.PackageRefactorHandler;
import edu.buffalo.cse.green.RefactorHandler;
import edu.buffalo.cse.green.editor.model.RootModel;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectRefactorHandler<E extends IJavaProject>
implements RefactorHandler<E> {
    private static final ProjectRefactorHandler<IJavaProject> INSTANCE = new ProjectRefactorHandler();

    private ProjectRefactorHandler() {
    }

    @Override
    public void handleAdd(RootModel root, E element) {
    }

    public static RefactorHandler<IJavaProject> instance() {
        return INSTANCE;
    }

    @Override
    public void handleMove(RootModel root, E sourceElement, E targetElement) {
        root.changeProjectElement((IJavaProject)sourceElement, (IJavaProject)targetElement);
        try {
            List<IJavaElement> packages = root.getElementsOfKind(4);
            for (IJavaElement packElement : packages) {
                IPackageFragment packFrag = (IPackageFragment)packElement;
                if (!JavaModelListener.sameElements(packFrag.getAncestor(2), sourceElement.getPrimaryElement())) continue;
                IPackageFragment[] iPackageFragmentArray = targetElement.getPackageFragments();
                int n = 0;
                int n2 = iPackageFragmentArray.length;
                while (n < n2) {
                    IPackageFragment packFrags = iPackageFragmentArray[n];
                    if (packFrag.getElementName().equals(packFrags.getElementName())) {
                        PackageRefactorHandler.instance().handleMove(root, packFrag, packFrags);
                    }
                    ++n;
                }
            }
            root.dispose();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleRemove(RootModel root, E element) {
        List<IJavaElement> packages = root.getElementsOfKind(4);
        for (IJavaElement pack : packages) {
            IJavaElement proj = pack.getAncestor(2);
            if (!JavaModelListener.sameElements(proj, element)) continue;
            PackageRefactorHandler.instance().handleRemove(root, (IPackageFragment)pack);
        }
    }
}

