/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.GreenWizard;
import java.util.MissingResourceException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ChooseTypeWizard
extends GreenWizard {
    private static final String ERROR_CONCRETE_CLASS = "The selected type must be a concrete class";
    private static final String ERROR_SELECT_TYPE = "You must select a concrete type to instantiate";
    protected ChooseTypeLabelProvider _labelProvider;
    protected IType _originalType;
    protected ITypeHierarchy _originalTypeHierarchy;
    protected IType _selectedType;

    public ChooseTypeWizard(IType originalType) {
        this._originalType = originalType;
        try {
            this._originalTypeHierarchy = this._originalType.newTypeHierarchy(PlugIn.getEmptyProgressMonitor());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new MissingResourceException("Can't load type hierarchy.", this._originalType.getFullyQualifiedName(), "TypeHierarchy");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doFinish() {
        try {
            if (this._selectedType == null) {
                GreenException.illegalOperation(ERROR_SELECT_TYPE);
                return false;
            }
            int flags = this._selectedType.getFlags();
            if (!Flags.isAbstract((int)flags)) {
                if (!Flags.isInterface((int)flags)) return true;
            }
            GreenException.illegalOperation(ERROR_CONCRETE_CLASS);
            return false;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void addPages() {
        super.addPages();
        ChooseTypeWizardPage page = new ChooseTypeWizardPage();
        page.setMessage("The type \"" + this._originalType.getElementName() + "\" cannot be used directly.");
        this.addPage((IWizardPage)page);
    }

    protected void typeSelected(IType selected) {
        this._selectedType = selected;
    }

    public IType getSelectedType() {
        return this._selectedType;
    }

    protected class ChooseTypeWizardPage
    extends WizardPage {
        private static final String DIALOG_TITLE = "Choose Concrete Type";

        protected ChooseTypeWizardPage() {
            super(DIALOG_TITLE);
            this.setTitle(DIALOG_TITLE);
            ChooseTypeWizard.this.setWindowTitle(DIALOG_TITLE);
            this.setMessage("The type cannot be used directly.");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            this.addTreeComponent(composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private void addTreeComponent(Composite parent) {
            TreeViewer fTreeViewer = new TreeViewer(parent, 2820);
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            GC gc = null;
            try {
                gc = new GC((Drawable)parent);
                gc.setFont(gc.getFont());
                gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)6);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                    gc = null;
                }
            }
            fTreeViewer.getTree().setLayoutData((Object)gd);
            fTreeViewer.setContentProvider((IContentProvider)new ChooseTypeContentProvider());
            ChooseTypeWizard.this._labelProvider = new ChooseTypeLabelProvider();
            fTreeViewer.setLabelProvider((IBaseLabelProvider)ChooseTypeWizard.this._labelProvider);
            ISelectionChangedListener listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ChooseTypeWizard.this.typeSelected((IType)selection.getFirstElement());
                }
            };
            fTreeViewer.addSelectionChangedListener(listener);
            fTreeViewer.setInput((Object)new Object[]{ChooseTypeWizard.this._originalType});
            fTreeViewer.expandToLevel(10);
        }
    }

    class ChooseTypeContentProvider
    implements ITreeContentProvider {
        ChooseTypeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement instanceof IType ? ChooseTypeWizard.this._originalTypeHierarchy.getSubtypes((IType)parentElement) : null;
        }

        public Object getParent(Object element) {
            return element instanceof IType ? ((IType)element).getParent().getAncestor(7) : null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                Object[] input = (Object[])inputElement;
                if (input.length == 0 || input[0] != ChooseTypeWizard.this._originalType) {
                    GreenException.illegalOperation("Root element of tree not original element.");
                }
                return new Object[]{ChooseTypeWizard.this._originalType};
            }
            GreenException.illegalOperation("Root element of tree not original element.");
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class ChooseTypeLabelProvider
    extends JavaElementLabelProvider
    implements IColorProvider {
        protected ChooseTypeLabelProvider() {
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

