/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.OKCancelComposite;
import edu.buffalo.cse.green.dialogs.OKCancelListener;
import edu.buffalo.cse.green.dialogs.VisibilityComposite;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.model.filters.MemberFilter;
import edu.buffalo.cse.green.editor.model.filters.MemberVisibility;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ManageFiltersDialog
extends Dialog
implements OKCancelListener {
    private Combo _behaveCombo;
    private Text _patternText;
    private Combo _typeCombo;
    private VisibilityComposite _visHolder;
    private Table _filterTable;

    public ManageFiltersDialog(Shell shell) {
        super(shell);
        this.create();
        this.getShell().setText("Manage Filters");
    }

    private void addFilter() {
        int i = this._typeCombo.getSelectionIndex();
        int enabled = 2 + this._behaveCombo.getSelectionIndex();
        boolean types = i == 1 || i == 3;
        boolean fields = i == 1 || i == 0;
        boolean methods = i == 1 || i == 2;
        int visibility = this._visHolder.getValue().intValue();
        String name = this._patternText.getText();
        if (!Pattern.matches("[a-zA-Z0-9?*_.]+", name)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid Pattern", (String)"Invalid Pattern");
        }
        this.addFilter(new MemberFilter(enabled, types, fields, methods, MemberVisibility.makeVisibility(visibility), name));
    }

    private void addFilter(MemberFilter filter) {
        TableItem tableItem = new TableItem(this._filterTable, 0);
        tableItem.setText(filter.getDescription());
        tableItem.setData((Object)filter);
        tableItem.setChecked(filter.isEnabled());
        this.resetOptions();
    }

    protected Control createContents(Composite parent) {
        Composite typeComposite = new Composite(parent, 0);
        typeComposite.setLayout((Layout)new GridLayout(4, false));
        Composite visComposite = new Composite(parent, 0);
        visComposite.setLayout((Layout)new GridLayout(2, false));
        Composite nameComposite = new Composite(parent, 0);
        nameComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 4;
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalSpan = 1;
        nameComposite.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(256);
        this._filterTable = new Table(parent, 32);
        this._filterTable.setLayout((Layout)new GridLayout(1, false));
        gd3.horizontalSpan = 1;
        this._filterTable.setLayoutData((Object)gd3);
        this._filterTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ManageFiltersDialog.this._filterTable.remove(ManageFiltersDialog.this._filterTable.getSelectionIndex());
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        OKCancelComposite buttonComposite = new OKCancelComposite(this, parent, true);
        buttonComposite.setLayout((Layout)new GridLayout(3, true));
        Label filterText = new Label(typeComposite, 0);
        filterText.setText("Filter all");
        this._typeCombo = new Combo(typeComposite, 8);
        this._behaveCombo = new Combo(typeComposite, 8);
        Label visText = new Label(visComposite, 0);
        visText.setText("visibility:");
        this._visHolder = new VisibilityComposite(visComposite, 0, true);
        Label nameText = new Label(nameComposite, 0);
        nameText.setText("name pattern:");
        this._patternText = new Text(nameComposite, 4);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this._patternText.setLayoutData((Object)gd);
        Button addFilterBut = new Button(nameComposite, 0);
        addFilterBut.setText("Add Filter");
        addFilterBut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManageFiltersDialog.this.addFilter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.resetOptions();
        for (MemberFilter filter : PlugIn.getMemberFilters()) {
            this.addFilter(filter);
        }
        parent.pack();
        return parent;
    }

    private void resetOptions() {
        this._behaveCombo.add("that meet the following conditions");
        this._behaveCombo.add("that do not meet the following conditions");
        this._behaveCombo.select(0);
        this._typeCombo.add("fields");
        this._typeCombo.add("members");
        this._typeCombo.add("methods");
        this._typeCombo.add("types");
        this._typeCombo.select(1);
        this._patternText.setText("*");
        this._visHolder.reset();
    }

    public void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    public void cancelPressed() {
        super.cancelPressed();
    }

    public void applyPressed() {
        StringBuffer buffer = new StringBuffer();
        if (this._filterTable.getItems().length > 0) {
            TableItem[] tableItemArray = this._filterTable.getItems();
            int n = 0;
            int n2 = tableItemArray.length;
            while (n < n2) {
                TableItem item = tableItemArray[n];
                MemberFilter filter = (MemberFilter)item.getData();
                if (item.getChecked() != filter.isEnabled()) {
                    int val = filter.getEnabledValue();
                    if (item.getChecked()) {
                        filter.setEnabled(val + 2);
                    } else {
                        filter.setEnabled(val - 2);
                    }
                }
                buffer.append("|");
                buffer.append(filter);
                ++n;
            }
        } else {
            buffer.append("|");
        }
        PlugIn.getDefault().getPreferenceStore().putValue("filters.member", buffer.toString().substring(1));
        for (DiagramEditor editor : DiagramEditor.getEditors()) {
            editor.refresh();
        }
    }
}

