/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.dialogs.NewElementWizard;
import edu.buffalo.cse.green.dialogs.NewElementWizardSettings;
import edu.buffalo.cse.green.dialogs.NewMemberSignatureWizardPage;
import edu.buffalo.cse.green.editor.model.TypeModel;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class NewFieldWizard
extends NewElementWizard {
    private NewFieldWizardPage fPage;
    private String _fieldName;
    private TypeModel _parent;
    private List<String> _modifiers;
    private String _typeName;

    public NewFieldWizard(TypeModel parent) {
        this._parent = parent;
        this._fieldName = "";
        this._typeName = "";
        this.setDialogSettings(PlugIn.getDefault().getDialogSettings());
        this.setWindowTitle("Add Field");
    }

    public void addPages() {
        super.addPages();
        this.fPage = new NewFieldWizardPage(this._parent.getType().getJavaProject());
        this.addPage((IWizardPage)this.fPage);
        try {
            this.fPage.setInterface(this._parent.isInterface());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public boolean doFinish() {
        boolean result = super.doFinish();
        if (this.fPage.getErrorMessage() != null) {
            result = false;
        }
        if (result) {
            this._fieldName = this.fPage.getName();
            this._modifiers = this.fPage.getModifiers();
            this._typeName = this.fPage.getTypeName();
        }
        return result;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public String getModifiers() {
        String modifiers = this._modifiers.toString();
        modifiers = modifiers.replaceAll(",", "");
        return modifiers.substring(1, modifiers.length() - 1);
    }

    public String getTypeName() {
        return this._typeName;
    }

    protected boolean canRunForked() {
        return true;
    }

    class NewFieldWizardPage
    extends NewMemberSignatureWizardPage {
        public NewFieldWizardPage(IJavaProject project) {
            super("AddFieldWizardPage");
            this.setTitle("Add Field");
            this.setDescription("Create a new Java field.");
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (this.isInterface()) {
                this.getVisibilityContainer().setDefaultEnabled(false);
                this.getVisibilityContainer().setPrivateEnabled(false);
                this.getVisibilityContainer().setProtectedEnabled(false);
                this.getVisibilityContainer().setPublicSelected(true);
            } else {
                this.getVisibilityContainer().setPrivateSelected(true);
            }
        }

        protected NewElementWizardSettings getSettings() {
            return this.isInterface() ? NewElementWizardSettings.InterfaceFieldSettings : NewElementWizardSettings.ClassFieldSettings;
        }

        protected boolean allowVoidType() {
            return false;
        }
    }
}

