/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.dialogs;

import edu.buffalo.cse.green.dialogs.IVisibilityChangedListener;
import edu.buffalo.cse.green.editor.model.filters.MemberVisibility;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

class VisibilityComposite
extends Composite {
    private MemberVisibility _value = MemberVisibility.PUBLIC;
    private Button _publicBut;
    private Button _defaultBut;
    private Button _privateBut;
    private Button _protectedBut;
    private List<IVisibilityChangedListener> _listeners = new ArrayList<IVisibilityChangedListener>();

    public VisibilityComposite(Composite parent, int style, boolean showAny) {
        super(parent, 4);
        this.setLayout((Layout)new GridLayout(showAny ? 8 : 7, false));
        if (showAny) {
            Button anyBut = new Button((Composite)this, 16);
            anyBut.setText("any");
            anyBut.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    VisibilityComposite.this._value = MemberVisibility.ANY;
                    VisibilityComposite.this.notifyListeners();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this._publicBut = new Button((Composite)this, 16);
        this._publicBut.setText("public");
        this._publicBut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityComposite.this._value = MemberVisibility.PUBLIC;
                VisibilityComposite.this.notifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._defaultBut = new Button((Composite)this, 16);
        this._defaultBut.setText("default");
        this._defaultBut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityComposite.this._value = MemberVisibility.DEFAULT;
                VisibilityComposite.this.notifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._privateBut = new Button((Composite)this, 16);
        this._privateBut.setText("private");
        this._privateBut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityComposite.this._value = MemberVisibility.PRIVATE;
                VisibilityComposite.this.notifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._protectedBut = new Button((Composite)this, 16);
        this._protectedBut.setText("protected");
        this._protectedBut.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityComposite.this._value = MemberVisibility.PROTECTED;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public MemberVisibility getValue() {
        return this._value;
    }

    public void addListener(IVisibilityChangedListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IVisibilityChangedListener listener) {
        this._listeners.remove(listener);
    }

    public void notifyListeners() {
        for (IVisibilityChangedListener listener : this._listeners) {
            listener.visibilityChanged(this._value);
        }
    }

    public void reset() {
        this._defaultBut.setSelection(false);
        this._privateBut.setSelection(false);
        this._protectedBut.setSelection(false);
        this._publicBut.setSelection(true);
    }

    public void setDefaultEnabled(boolean enable) {
        this._defaultBut.setEnabled(enable);
    }

    public void setPrivateEnabled(boolean enable) {
        this._privateBut.setEnabled(enable);
    }

    public void setProtectedEnabled(boolean enable) {
        this._protectedBut.setEnabled(enable);
    }

    public void setPublicEnabled(boolean enable) {
        this._publicBut.setEnabled(enable);
    }

    public void setDefaultSelected(boolean select) {
        this._defaultBut.setSelection(select);
        this._value = MemberVisibility.DEFAULT;
    }

    public void setPrivateSelected(boolean select) {
        this._privateBut.setSelection(select);
        this._value = MemberVisibility.PRIVATE;
    }

    public void setProtectedSelected(boolean select) {
        this._protectedBut.setSelection(select);
        this._value = MemberVisibility.PROTECTED;
    }

    public void setPublicSelected(boolean select) {
        this._publicBut.setSelection(select);
        this._value = MemberVisibility.PUBLIC;
    }
}

