/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.editor.action.QuickFix;
import edu.buffalo.cse.green.editor.action.QuickFixAction;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberModel<C extends AbstractModel, P extends AbstractModel, E extends IMember>
extends AbstractModel<C, P, E> {
    private static JavaElementLabelProvider ICON_PROVIDER = new JavaElementLabelProvider();
    private E _member = null;

    protected MemberModel(E element) {
        this.setMember(element);
    }

    @Override
    public final E getJavaElement() {
        return this._member;
    }

    public final E getMember() {
        return this._member;
    }

    public final void setMember(E member) {
        E oldMember = this._member;
        this._member = member;
        this.firePropertyChange(PropertyChange.Element, oldMember, this._member);
    }

    protected String getVisibility() {
        block9: {
            int flags;
            block8: {
                block7: {
                    flags = this._member.getFlags();
                    if ((flags & 1) != 1) break block7;
                    return "public";
                }
                if ((flags & 4) != 4) break block8;
                return "protected";
            }
            if ((flags & 2) != 2) break block9;
            return "private";
        }
        try {
            if (!false) {
                return "";
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void removeFromParent() {
        ((AbstractModel)this.getParent()).removeChild(this);
    }

    protected Image getImage(MemberModel<?, ?, E> model) {
        E member = model.getMember();
        ImageDescriptor id = ImageDescriptor.createFromImage((Image)ICON_PROVIDER.getImage(member));
        int adornments = 0;
        IResource memberResource = member.getResource();
        if (memberResource != null && member instanceof IMember && member.exists()) {
            try {
                IMarker[] errorMarkers;
                IMarker[] iMarkerArray = errorMarkers = memberResource.findMarkers("org.eclipse.jdt.core.problem", false, 0);
                int n = 0;
                int n2 = iMarkerArray.length;
                while (n < n2) {
                    IMarker marker = iMarkerArray[n];
                    int errStart = (Integer)marker.getAttribute("charStart");
                    int errEnd = (Integer)marker.getAttribute("charEnd");
                    int memStart = member.getSourceRange().getOffset();
                    int memEnd = memStart + member.getSourceRange().getLength();
                    if (memStart <= errStart && memEnd >= errEnd) {
                        int severity = marker.getAttribute("severity", 0);
                        if (severity == 2) {
                            adornments = 64;
                            break;
                        }
                        if (severity == 1) {
                            adornments = 32;
                        }
                    }
                    ++n;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return new JavaElementImageDescriptor(id, adornments, new Point(id.getImageData().width, id.getImageData().height)).createImage();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void handleDispose() {
    }

    public Image getIcon() {
        return this.getImage(this);
    }

    public abstract String getDisplayName();

    protected static final String getSignatureName(String signature, boolean fqn) {
        String sig = Signature.toString((String)signature);
        if (!fqn) {
            sig = sig.substring(sig.lastIndexOf(46) + 1);
        }
        return sig;
    }

    @Override
    public TypeModel getTypeModel() {
        Object parent = this.getParent();
        return ((AbstractModel)parent).getTypeModel();
    }

    public abstract RenameSupport getRenameSupport() throws CoreException;

    public void appendQuickFixActionsToMenu(MenuManager menu) {
        List<QuickFix> fixes = this.getQuickFixes();
        if (fixes.size() > 0) {
            menu.add((IContributionItem)new Separator());
            for (QuickFix fix : fixes) {
                menu.add((IAction)new QuickFixAction(fix));
            }
        }
    }

    private List<QuickFix> getQuickFixes() {
        boolean isBinary = this.getMember().isBinary();
        if (!isBinary) {
            try {
                IMarker[] errorMarkers;
                IResource resource = this.getMember().getUnderlyingResource();
                IMarker[] iMarkerArray = errorMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", false, 0);
                int n = 0;
                int n2 = iMarkerArray.length;
                while (n < n2) {
                    IMarker marker = iMarkerArray[n];
                    int errStart = (Integer)marker.getAttribute("charStart");
                    int errEnd = (Integer)marker.getAttribute("charEnd");
                    int memStart = this.getMember().getSourceRange().getOffset();
                    int memEnd = memStart + this.getMember().getSourceRange().getLength();
                    if (memStart <= errStart && memEnd >= errEnd) {
                        return this.getQuickFix(marker);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
        return new ArrayList<QuickFix>();
    }

    private List<QuickFix> getQuickFix(IMarker errorMarker) {
        ArrayList<QuickFix> fixes = new ArrayList<QuickFix>();
        IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(errorMarker);
        int n = 0;
        int n2 = iMarkerResolutionArray.length;
        while (n < n2) {
            IMarkerResolution resolution = iMarkerResolutionArray[n];
            fixes.add(new QuickFix(errorMarker, resolution));
            ++n;
        }
        return fixes;
    }
}

