/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.MethodPart;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.CompartmentModel;
import edu.buffalo.cse.green.editor.model.MemberModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteMethodCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.refactoring.RenameSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodModel
extends MemberModel<AbstractModel, CompartmentModel, IMethod> {
    public MethodModel(IMethod method) {
        super(method);
    }

    @Override
    public String getDisplayName() {
        if (!((IMethod)this.getMember()).exists()) {
            return "";
        }
        return MethodModel.getMethodSignature(this.getMethod());
    }

    public IMethod getMethod() {
        return (IMethod)this.getMember();
    }

    @Override
    public int getContextMenuFlag() {
        return 4;
    }

    public boolean isAbstract() {
        try {
            return ((IMethod)this.getMember()).exists() && Flags.isAbstract((int)((IMethod)this.getMember()).getFlags());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public Command getHideCommand(DiagramEditor editor) {
        return null;
    }

    @Override
    public Class getPartClass() {
        return MethodPart.class;
    }

    @Override
    public DeleteCommand getDeleteCommand(DiagramEditor editor) {
        return new DeleteMethodCommand(this);
    }

    @Override
    public void removeFromParent() {
        super.removeFromParent();
    }

    @Override
    public RenameSupport getRenameSupport() throws CoreException {
        return RenameSupport.create((IMethod)this.getMethod(), (String)"", (int)1);
    }

    public static String getMethodSignature(IMethod method) {
        boolean displayParameters = PlugIn.getBooleanPreference("display.method.parameters");
        boolean fqn = PlugIn.getBooleanPreference("display.fqn.type.names");
        try {
            String[] names;
            String returnType = "";
            String methodName = method.getElementName();
            String parameters = "(";
            if (!method.isConstructor()) {
                returnType = String.valueOf(MethodModel.getSignatureName(method.getReturnType(), fqn)) + " ";
            }
            String[] types = method.getParameterTypes();
            try {
                names = method.getParameterNames();
            }
            catch (JavaModelException javaModelException) {
                names = null;
            }
            StringBuffer param = new StringBuffer();
            int i = 0;
            while (i < method.getParameterTypes().length) {
                param.append(", ");
                param.append(MethodModel.getSignatureName(types[i], fqn));
                if (names != null && displayParameters) {
                    param.append(" " + names[i]);
                }
                ++i;
            }
            if (param.toString().length() > 0) {
                parameters = String.valueOf(parameters) + param.toString().substring(2);
            }
            parameters = String.valueOf(parameters) + ")";
            return String.valueOf(returnType) + methodName + parameters;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return "";
        }
    }
}

