/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.RelationshipPart;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.NoteModel;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.relationships.RelationshipCache;
import edu.buffalo.cse.green.xml.XMLConverter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootModel
extends AbstractModel<AbstractModel, AbstractModel, IJavaElement> {
    private IJavaProject _project;
    private RootModelCache _cache = new RootModelCache();
    private List<RelationshipModel> _relationshipModels;
    private RelationshipCache _relationships = new RelationshipCache();

    public RootModel() {
        this._relationshipModels = new ArrayList<RelationshipModel>();
    }

    public RelationshipCache getRelationshipCache() {
        return this._relationships;
    }

    @Override
    public RootModel getRootModel() {
        return this;
    }

    protected void removeChildModel(TypeModel model) {
        ArrayList<RelationshipModel> edges = new ArrayList<RelationshipModel>();
        edges.addAll(model.getIncomingEdges());
        edges.addAll(model.getOutgoingEdges());
        for (RelationshipModel rModel : edges) {
            rModel.removeFromParent();
        }
    }

    protected void removeChildModel(RelationshipModel model) {
        this.getRelationshipCache().removeRelationshipModel(model);
        this._relationshipModels.remove(model);
        this.removeChild(model);
    }

    public void generateRelationshipCode(RelationshipModel rModel) {
        this.firePropertyChange(PropertyChange.GenerateRelationship, null, rModel);
    }

    public List<RelationshipModel> getRelationships() {
        return this._relationshipModels;
    }

    public void hideRelationshipsOfType(Class partClass) {
        if (RelationshipPart.class.isAssignableFrom(partClass)) {
            for (RelationshipModel rModel : this.getRelationshipsOfType(partClass)) {
                rModel.setVisible(false);
            }
        } else {
            GreenException.illegalOperation("Wrong type of object specified");
        }
    }

    public List<RelationshipModel> getRelationshipsOfType(Class partClass) {
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (RelationshipModel rModel : this.getRelationships()) {
            if (!rModel.getPartClass().equals(partClass)) continue;
            relationships.add(rModel);
        }
        return relationships;
    }

    public void showRelationshipsOfType(Class partClass) {
        if (RelationshipPart.class.isAssignableFrom(partClass)) {
            for (RelationshipModel rModel : this.getRelationshipsOfType(partClass)) {
                rModel.setVisible(true);
            }
        } else {
            GreenException.illegalOperation("Wrong type of object specified");
        }
    }

    public TypeModel getModelFromType(IType type) {
        return (TypeModel)this._cache.getModel((IJavaElement)type);
    }

    public TypeModel createTypeModel(IType type) {
        TypeModel typeModel = (TypeModel)this.getModelFromElement((IJavaElement)type);
        if (typeModel == null) {
            typeModel = new TypeModel(type);
            if (PlugIn.filterMember(typeModel)) {
                this.removeChild(typeModel);
                return typeModel;
            }
            typeModel.setParent(this);
            GreenException.illegalOperation(this.isValidTypeModel(typeModel));
            typeModel.updateFields();
            typeModel.updateMethods();
            if (typeModel.getType().isBinary()) {
                typeModel.setParent(this);
            }
            this.addChild(typeModel, (IJavaElement)typeModel.getMember());
            if (this._project == null) {
                if (!type.isBinary()) {
                    this.setProject((IJavaProject)type.getAncestor(2));
                }
            } else if (!type.getAncestor(2).equals(this._project)) {
                GreenException.warn("Element added to wrong editor");
            }
        } else {
            if (PlugIn.filterMember(typeModel)) {
                this.removeChild(typeModel);
                return typeModel;
            }
            typeModel.setVisible(true);
        }
        for (RelationshipModel rModel : this._relationshipModels) {
            TypeModel rsModel = rModel.getSourceModel();
            TypeModel rtModel = rModel.getTargetModel();
            if (rsModel == null || rtModel == null || !typeModel.equals(rsModel) && !typeModel.equals(rtModel) || !rsModel.isVisible() || !rtModel.isVisible()) continue;
            rModel.setSourceModel(rsModel);
            rModel.setTargetModel(rtModel);
            rModel.setVisible(true);
        }
        return typeModel;
    }

    public void mapElementToModel(IJavaElement element, AbstractModel model) {
        this._cache.putModel(element, model);
    }

    public void unmapElement(IJavaElement element) {
        this._cache.removeElement(element);
    }

    public AbstractModel getModelFromElement(IJavaElement element) {
        return this._cache.getModel(element);
    }

    @Override
    public void toXML(XMLConverter converter) {
        converter.pushHeader("uml");
        converter.writeKey("greenVersion", PlugIn.getVersion());
        super.toXML(converter);
        converter.popHeader();
    }

    public IJavaProject getProject() {
        return this._project;
    }

    public void setProject(IJavaProject project) {
        this._project = project;
    }

    public String isValidTypeModel(TypeModel model) {
        if (model.getType() == null) {
            return "Type is null";
        }
        return model.getType().getPackageFragment().isDefaultPackage() ? "Cannot use default package in editor for type" : null;
    }

    private static List<AbstractModel> getModels(AbstractModel root, ModelFilter predicate) {
        ArrayList<AbstractModel> listToAddTo = new ArrayList<AbstractModel>();
        ArrayList<AbstractModel> queueToCheck = new ArrayList<AbstractModel>();
        queueToCheck.add(root);
        while (!queueToCheck.isEmpty()) {
            AbstractModel modelToCheck = (AbstractModel)queueToCheck.remove(0);
            if (predicate.isAcceptable(modelToCheck)) {
                listToAddTo.add(modelToCheck);
            }
            ArrayList children = (ArrayList)modelToCheck.getChildren();
            queueToCheck.addAll(children);
        }
        return listToAddTo;
    }

    public static List<AbstractModel> getModels(AbstractModel root, final Class type) {
        return RootModel.getModels(root, new ModelFilter(){

            public boolean isAcceptable(AbstractModel modelToCheck) {
                return type.isInstance(modelToCheck);
            }
        });
    }

    public List<IClassFile> getClassFiles() {
        ArrayList<IClassFile> classFiles = new ArrayList<IClassFile>();
        for (AbstractModel model : RootModel.getModels((AbstractModel)this, TypeModel.class)) {
            TypeModel typeModel = (TypeModel)model;
            if (!typeModel.getType().isBinary()) continue;
            classFiles.add((IClassFile)typeModel.getType().getAncestor(6));
        }
        return classFiles;
    }

    @Override
    public Class getPartClass() {
        return RootPart.class;
    }

    @Override
    public void handleDispose() {
    }

    public void changeProjectElement(IJavaProject sourceProject, IJavaProject targetProject) {
        if (!this._project.equals(sourceProject)) {
            GreenException.illegalOperation("The editor whose project was reset did not have the specified old project");
        }
        this._project = targetProject;
    }

    @Override
    public DeleteCommand getDeleteCommand(DiagramEditor editor) {
        return null;
    }

    @Override
    public IJavaElement getJavaElement() {
        return null;
    }

    public void addChild(NoteModel model) {
        this.addChild(model, null);
    }

    public void addChild(RelationshipModel model) {
        TypeModel sourceModel = model.getSourceModel();
        TypeModel targetModel = model.getTargetModel();
        this._relationshipModels.add(model);
        this.addChild(model, null);
        model.setSourceModel(sourceModel);
        model.setTargetModel(targetModel);
        sourceModel.addOutgoingEdge(model);
        targetModel.addIncomingEdge(model);
    }

    @Override
    public void removeFromParent() {
        GreenException.illegalOperation("Cannot remove root model");
    }

    public void updateRelationships() {
        this.firePropertyChange(PropertyChange.UpdateRelationships);
    }

    @Override
    public String toString() {
        return this._project.getElementName();
    }

    public List<IJavaElement> getElementsOfKind(int kind) {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        for (IJavaElement element : this._cache.getElements()) {
            IJavaElement ancestor;
            if (element == null || (ancestor = element.getAncestor(kind)) == null) continue;
            ids.add(ancestor.getHandleIdentifier());
        }
        for (String id : ids) {
            elements.add(JavaCore.create((String)id));
        }
        return elements;
    }

    public boolean ancestorInEditor(IJavaElement ancestor) {
        List<IJavaElement> elements = this.getElementsOfKind(ancestor.getElementType());
        for (IJavaElement element : elements) {
            if (!element.getHandleIdentifier().equals(ancestor.getHandleIdentifier())) continue;
            return true;
        }
        return false;
    }

    public void placeUMLBox(TypeModel model) {
        int boxWidth = 200;
        int boxHeight = 200;
        int maxWidth = 600;
        int maxHeight = 800;
        int y = 0;
        while (y <= maxHeight) {
            int x = 0;
            while (x <= maxWidth) {
                boolean fail = false;
                for (AbstractModel element : this.getChildren()) {
                    TypeModel sibling;
                    if (!(element instanceof TypeModel) || (sibling = (TypeModel)element).equals(model) || sibling.getLocation().x <= x - boxWidth / 2 || sibling.getLocation().x >= x + boxWidth / 2 || sibling.getLocation().y <= y - boxHeight / 2 || sibling.getLocation().y >= y + boxHeight / 2) continue;
                    fail = true;
                    break;
                }
                if (!fail) {
                    model.setLocation(new Point(x, y));
                    return;
                }
                x += boxWidth;
            }
            y += boxHeight;
        }
        model.setLocation(new Point(50, 50));
    }

    @Override
    public void refresh() {
        this.updateTypes();
        super.refresh();
    }

    private void updateTypes() {
        for (TypeModel typeModel : (AbstractList)this.getChildren(TypeModel.class)) {
            if (!PlugIn.filterMember(typeModel)) continue;
            typeModel.removeFromParent();
        }
    }

    private static interface ModelFilter {
        public boolean isAcceptable(AbstractModel var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RootModelCache {
        private HashMap<String, AbstractModel> _elementMapToModel = new HashMap();

        public void putModel(IJavaElement element, AbstractModel model) {
            if (element == null) {
                GreenException.illegalOperation("Argument is null.");
            }
            if (model == null) {
                GreenException.illegalOperation("Argument is null.");
            }
            this.putModelWithElement(element, model);
        }

        public Set<IJavaElement> getElements() {
            Set<String> handles = this._elementMapToModel.keySet();
            HashSet<IJavaElement> elements = new HashSet<IJavaElement>();
            for (String handle : handles) {
                elements.add(JavaCore.create((String)handle));
            }
            return elements;
        }

        public AbstractModel getModel(IJavaElement element) {
            if (element == null) {
                GreenException.illegalOperation("Argument is null.");
            }
            return this._elementMapToModel.get(element.getHandleIdentifier());
        }

        private void putModelWithElement(IJavaElement element, AbstractModel model) {
            this._elementMapToModel.put(element.getHandleIdentifier(), model);
        }

        private AbstractModel removeElement(IJavaElement element) {
            return this._elementMapToModel.remove(element.getHandleIdentifier());
        }
    }
}

