/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.commands;

import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteBendpointCommand;
import edu.buffalo.cse.green.editor.view.GreenBendpoint;
import edu.buffalo.cse.green.editor.view.RelationshipFigure;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;

public class CreateBendpointCommand
extends Command {
    private BendpointRequest _request;
    private RelationshipFigure _figure;

    public CreateBendpointCommand(RelationshipFigure rFigure, BendpointRequest request) {
        this._figure = rFigure;
        this._request = request;
    }

    public GreenBendpoint getBendpoint(BendpointRequest request) {
        GreenBendpoint bendpoint = new GreenBendpoint(this._figure);
        bendpoint.setAbsoluteLocation(request.getLocation());
        return bendpoint;
    }

    public void execute() {
        if (this._figure.isRecursive()) {
            return;
        }
        GreenBendpoint bendpoint = this.getBendpoint(this._request);
        RelationshipModel rModel = (RelationshipModel)this._request.getSource().getModel();
        List constraint = (List)this._figure.getConnectionRouter().getConstraint((Connection)this._figure);
        ArrayList<GreenBendpoint> list = (ArrayList<GreenBendpoint>)constraint;
        if (list == null) {
            list = new ArrayList<GreenBendpoint>();
            rModel.setBendpointList(list);
        }
        if (this._request.getIndex() == -1) {
            this._request.setIndex(list.size());
        }
        list.add(this._request.getIndex(), bendpoint);
        this._figure.getConnectionRouter().setConstraint((Connection)this._figure, list);
        this._figure.anchorMoved(this._figure.getSourceAnchor());
        this._figure.anchorMoved(this._figure.getTargetAnchor());
        this._figure.repaint();
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        BendpointRequest request = new BendpointRequest();
        request.setIndex(this._request.getIndex());
        request.setLocation(this._request.getLocation());
        request.setSource(this._request.getSource());
        request.setType((Object)"move bendpoint");
        new DeleteBendpointCommand(request).execute();
    }
}

