/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.model.commands;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class SetConstraintCommand
extends Command {
    private Point _oldPos;
    private Point _newPos;
    private Dimension _oldSize;
    private Dimension _newSize;
    private AbstractModel _model;

    public SetConstraintCommand(AbstractModel model) {
        this._model = model;
    }

    public void execute() {
        this._oldSize = this._model.getSize();
        this._oldPos = this._model.getLocation();
        this._model.setLocation(this._newPos);
        this._model.setSize(this._newSize);
    }

    public void redo() {
        this.execute();
    }

    public void setBounds(Rectangle r) {
        String sGridSize = PlugIn.getPreference("grid.size");
        int gridSize = 1;
        try {
            gridSize = Integer.parseInt(sGridSize);
            if (gridSize < 1) {
                gridSize = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GreenException.warn("Cannot parse grid size: " + sGridSize);
        }
        if (gridSize != 1) {
            int x = r.getLocation().x + gridSize / 2;
            x /= gridSize;
            int y = r.getLocation().y + gridSize / 2;
            y /= gridSize;
            if (!r.getSize().equals((Object)new Dimension(-1, -1))) {
                int width = r.getSize().width + gridSize / 2;
                int height = r.getSize().height + gridSize / 2;
                this._newSize = new Dimension((width /= gridSize) * gridSize, (height /= gridSize) * gridSize);
            } else {
                this._newSize = r.getSize();
            }
            this._newPos = new Point(x * gridSize, y * gridSize);
        } else {
            this._newPos = r.getLocation();
            this._newSize = r.getSize();
        }
    }

    public void undo() {
        this._model.setSize(this._oldSize);
        this._model.setLocation(this._oldPos);
    }

    public boolean canUndo() {
        return true;
    }
}

