/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.relationships;

import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.relationships.Relationship;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipCache {
    private Map<IType, Map<IType, Map<String, RelationshipModel>>> _models = new HashMap<IType, Map<IType, Map<String, RelationshipModel>>>();
    private Set<RelationshipModel> _changes = new HashSet<RelationshipModel>();

    public void removeRelationshipModel(RelationshipModel rModel) {
        this._models.get(rModel.getSourceType()).get(rModel.getTargetType()).remove(rModel.getPartClass().getName());
    }

    public RelationshipModel getRelationshipModel(IType source, IType target, String name) {
        Map<IType, Map<String, RelationshipModel>> targetMap = this._models.get(source);
        if (targetMap == null) {
            return null;
        }
        Map<String, RelationshipModel> classMap = targetMap.get(target);
        if (classMap == null) {
            return null;
        }
        return classMap.get(name);
    }

    private RelationshipModel getRelationshipModel(IType source, IType target, Class klass) {
        RelationshipModel rModel;
        Map<String, RelationshipModel> classMap;
        Map<IType, Map<String, RelationshipModel>> targetMap = this._models.get(source);
        if (targetMap == null) {
            targetMap = new HashMap<IType, Map<String, RelationshipModel>>();
            this._models.put(source, targetMap);
        }
        if ((classMap = targetMap.get(target)) == null) {
            classMap = new HashMap<String, RelationshipModel>();
            targetMap.put(target, classMap);
        }
        if ((rModel = classMap.get(klass.getName())) == null) {
            rModel = new RelationshipModel(source, target, klass);
            classMap.put(klass.getName(), rModel);
        }
        return rModel;
    }

    public void add(IType source, IType target, Class klass, Relationship relationship) {
        RelationshipModel rModel = this.getRelationshipModel(source, target, klass);
        Relationship eRelationship = rModel.contains(relationship);
        if (eRelationship == null) {
            rModel.addRelationship(relationship);
            relationship.setRetained(true);
            this._changes.add(rModel);
        } else {
            eRelationship.setRetained(true);
        }
    }

    public Set<RelationshipModel> processChanges() {
        for (Map<IType, Map<String, RelationshipModel>> map1 : this._models.values()) {
            for (Map<String, RelationshipModel> map2 : map1.values()) {
                for (RelationshipModel rModel : map2.values()) {
                    Iterator<Relationship> iter = rModel.getRelationships().iterator();
                    while (iter.hasNext()) {
                        Relationship relationship = iter.next();
                        if (!relationship.isRetained()) {
                            iter.remove();
                            this._changes.add(rModel);
                            continue;
                        }
                        relationship.setRetained(false);
                    }
                }
            }
        }
        return this._changes;
    }

    public List<RelationshipModel> getRelationships(Class klass) {
        ArrayList<RelationshipModel> relationships = new ArrayList<RelationshipModel>();
        for (Map<IType, Map<String, RelationshipModel>> map : this._models.values()) {
            for (Map<String, RelationshipModel> map2 : map.values()) {
                if (map2.get(klass.getName()) == null) continue;
                relationships.add(map2.get(klass.getName()));
            }
        }
        return relationships;
    }

    public Set<RelationshipModel> getRelationships(IType type) {
        HashSet<RelationshipModel> models = new HashSet<RelationshipModel>();
        Map<IType, Map<String, RelationshipModel>> map = this._models.get(type);
        if (map == null) {
            return models;
        }
        for (Map<String, RelationshipModel> map2 : map.values()) {
            models.addAll(map2.values());
        }
        return models;
    }
}

