/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.relationships;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.relationships.Relationship;
import edu.buffalo.cse.green.relationships.RelationshipCache;
import edu.buffalo.cse.green.relationships.RelationshipVisitor;
import edu.buffalo.cse.green.util.IModifiableBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class RelationshipRemover
extends RelationshipVisitor {
    private RelationshipModel _rModel;
    private Relationship _relationship;

    protected IType getSourceType() {
        return this._rModel.getSourceType();
    }

    protected IType getTargetType() {
        return this._rModel.getTargetType();
    }

    protected Relationship getRelationship() {
        return this._relationship;
    }

    public void setRelationship(RelationshipModel rModel) {
        this._rModel = rModel;
    }

    public final void run(CompilationUnit cu, RelationshipCache cache) {
        if (this._rModel == null) {
            throw new IllegalStateException("The relationship to remove hasn't been set");
        }
        try {
            ICompilationUnit iCU = (ICompilationUnit)this.getSourceType().getAncestor(5);
            cu.recordModifications();
            Iterator<Relationship> iterator = this._rModel.getRelationships().iterator();
            while (iterator.hasNext()) {
                Relationship relationship;
                this._relationship = relationship = iterator.next();
                this.init();
                cu.accept((ASTVisitor)this);
                this.finish();
            }
            IModifiableBuffer sourceDoc = new IModifiableBuffer(iCU.getBuffer());
            TextEdit textEdit = cu.rewrite((IDocument)sourceDoc, null);
            textEdit.apply((IDocument)sourceDoc);
            if (!iCU.isConsistent()) {
                iCU.save(PlugIn.getEmptyProgressMonitor(), false);
            }
            this.organizeImports(this.getSourceType());
            DiagramEditor.getActiveEditor().refresh();
            this._rModel.getSourceModel().forceRefesh();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected abstract void finish();

    protected abstract void init();

    protected void relationshipRemovalError() {
        GreenException.illegalOperation("Couldn't remove relationship");
    }

    protected void processAddInvocations(Block block) {
        AbstractList stmts = (AbstractList)block.statements();
        ArrayList<ExpressionStatement> toRemove = new ArrayList<ExpressionStatement>();
        int x = 1;
        while (x < this._relationship.getFeatures().size()) {
            stmts.removeAll(toRemove);
            toRemove.clear();
            for (Statement statement : stmts) {
                ExpressionStatement e;
                if (statement.getNodeType() != 21 || !new ASTMatcher().match(e = (ExpressionStatement)statement, (Object)this._relationship.getFeatures().get(x))) continue;
                toRemove.add(e);
                break;
            }
            ++x;
        }
        stmts.removeAll(toRemove);
    }
}

