/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.relationships;

import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.relationships.DeclarationInfoProvider;
import edu.buffalo.cse.green.relationships.RelationshipCache;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipVisitor
extends ASTVisitor {
    private ASTMatcher _matcher = new ASTMatcher();
    private MethodDeclaration _methodDeclaration;
    private AST _ast;
    private CompilationUnit _cu;
    private boolean _inConstructor = false;
    private List<String> _locals;
    private List<String> _parameters;
    private List<ILocalVariable> _parameterVars;
    private Stack<DeclarationInfoProvider> _typeStack = new Stack();

    public static CompilationUnit getCompilationUnit(IMember element) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        if (element.isBinary()) {
            parser.setSource((IClassFile)element.getAncestor(6));
        } else {
            parser.setSource((ICompilationUnit)element.getAncestor(5));
        }
        return (CompilationUnit)parser.createAST(null);
    }

    protected RelationshipVisitor() {
        this._locals = new ArrayList<String>();
        this._parameters = new ArrayList<String>();
        this._parameterVars = new ArrayList<ILocalVariable>();
    }

    public void accept(CompilationUnit cu) {
        this._ast = cu.getAST();
        this._cu = cu;
        this.preVisit();
        this.run(cu, null);
    }

    protected void preVisit() {
    }

    public final void endVisit(MethodDeclaration node) {
        this._methodDeclaration = null;
        this._parameters.clear();
        this._parameterVars.clear();
        this._inConstructor = false;
    }

    public final void endVisit(EnumDeclaration node) {
        this.endVisit((TypeDeclaration)null);
    }

    public final void endVisit(TypeDeclaration node) {
        this._typeStack.pop();
    }

    protected AST getAST() {
        return this._ast;
    }

    protected CompilationUnit getCompilationUnit() {
        return this._cu;
    }

    public CompilationUnit getCompilationUnit(IClassFile element) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(element);
        return (CompilationUnit)parser.createAST(null);
    }

    public CompilationUnit getCompilationUnit(ICompilationUnit element) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(element);
        return (CompilationUnit)parser.createAST(null);
    }

    public CompilationUnit getCompilationUnit(IType element) {
        if (element.isBinary()) {
            return this.getCompilationUnit((IClassFile)element.getAncestor(6));
        }
        return this.getCompilationUnit((ICompilationUnit)element.getAncestor(5));
    }

    public IType getType(DeclarationInfoProvider provider) {
        return this.getType(provider.getDeclaration().resolveBinding());
    }

    public IType getType(Type type) {
        return this.getType(type.resolveBinding());
    }

    public IType getType(ITypeBinding binding) {
        return (IType)binding.getJavaElement();
    }

    protected abstract boolean process(DeclarationInfoProvider var1);

    protected abstract void run(CompilationUnit var1, RelationshipCache var2);

    public final boolean visit(MethodDeclaration node) {
        if ((node.getModifiers() & 8) != 0) {
            return true;
        }
        this._inConstructor = node.isConstructor();
        this._methodDeclaration = node;
        for (SingleVariableDeclaration varDec : (AbstractList)node.parameters()) {
            SimpleName parameter = varDec.getName();
            this._parameters.add(parameter.getIdentifier());
            this._parameterVars.add((ILocalVariable)parameter.resolveBinding().getJavaElement());
        }
        return true;
    }

    public final boolean visit(EnumDeclaration node) {
        return this.visit(DeclarationInfoProvider.getInfoProvider(node));
    }

    public final boolean visit(TypeDeclaration node) {
        return this.visit(DeclarationInfoProvider.getInfoProvider(node));
    }

    public final boolean visit(DeclarationInfoProvider node) {
        this._typeStack.push(node);
        return this.process(node);
    }

    private boolean isLocalVariable(ILocalVariable var) {
        return !this.isParameter(var);
    }

    private boolean isParameter(ILocalVariable var) {
        for (ILocalVariable param : this._parameterVars) {
            if (!param.equals(var)) continue;
            return true;
        }
        return false;
    }

    protected boolean isField(Name name) {
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return false;
        }
        return binding.getJavaElement().getElementType() == 8;
    }

    protected boolean isParameter(Name name) {
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return false;
        }
        IJavaElement element = binding.getJavaElement();
        if (element.getElementType() != 14) {
            return false;
        }
        return this.isParameter((ILocalVariable)element);
    }

    protected boolean isLocalVariable(Name name) {
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return false;
        }
        IJavaElement element = binding.getJavaElement();
        if (element == null) {
            return false;
        }
        if (element.getElementType() != 14) {
            return false;
        }
        return this.isLocalVariable((ILocalVariable)element);
    }

    protected boolean isFieldDeclared(String name) {
        return this.getFieldNames().contains(name);
    }

    protected void organizeImports(ICompilationUnit cu) {
        new OrganizeImportsAction((IWorkbenchSite)DiagramEditor.getActiveEditor().getSite()).runOnMultiple(new ICompilationUnit[]{cu});
    }

    protected void organizeImports(IType type) {
        this.organizeImports(type.getCompilationUnit());
    }

    protected boolean inConstructor() {
        return this._inConstructor;
    }

    protected IType getCurrentType() {
        AbstractTypeDeclaration typeDec = this.getCurrentTypeDeclaration();
        return (IType)typeDec.resolveBinding().getJavaElement();
    }

    protected List<String> getLocalDeclarations() {
        return this._locals;
    }

    protected List<String> getParameterDeclarations() {
        return this._parameters;
    }

    protected MethodDeclaration getMethodDeclaration() {
        return this._methodDeclaration;
    }

    protected ASTMatcher getMatcher() {
        return this._matcher;
    }

    protected DeclarationInfoProvider getCurrentTypeInfo() {
        return this._typeStack.peek();
    }

    protected List<BodyDeclaration> getBodyDeclarations() {
        return (AbstractList)this.getCurrentTypeInfo().bodyDeclarations();
    }

    protected AbstractTypeDeclaration getCurrentTypeDeclaration() {
        return this.getCurrentTypeInfo().getDeclaration();
    }

    protected List<String> getFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DeclarationInfoProvider typeInfo : this._typeStack) {
            fieldNames.addAll(DeclarationInfoProvider.getFieldNames(typeInfo.getFields()));
        }
        return fieldNames;
    }

    protected List<FieldDeclaration> getFields() {
        return this.getCurrentTypeInfo().getFields();
    }
}

