/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.util;

import edu.buffalo.cse.green.PlugIn;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ImageWriterUtil {
    public static final int FORMAT_BMP = 0;
    public static final int FORMAT_GIF = 2;
    public static final int FORMAT_JPG = 4;
    public static final int FORMAT_PNG = 5;
    public static final int FORMAT_TIF = 6;
    private static RGB[] GRAYSCALE_COLORS;
    private static RGB[] GREEN_COLORS;
    private static final int GREEN_COLOR_BACKGROUND;

    static {
        int startIndexBase;
        GRAYSCALE_COLORS = new RGB[256];
        int c = 0;
        while (c < GRAYSCALE_COLORS.length) {
            ImageWriterUtil.GRAYSCALE_COLORS[c] = new RGB(c, c, c);
            ++c;
        }
        HashSet<RGB> basicColorSet = new HashSet<RGB>();
        basicColorSet.add(ImageWriterUtil.getRGB(ColorConstants.listBackground));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.uml")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.type.border")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.type.border.hiddenr")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.type.text")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.compartment.border")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.note")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.note.border")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.note.text")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.rel.arrow.fill")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.rel.line")));
        basicColorSet.add(ImageWriterUtil.getRGB(PlugIn.getColorPreference("color.rel.text")));
        GREEN_COLORS = new RGB[256];
        basicColorSet.toArray(GREEN_COLORS);
        int c2 = startIndexBase = basicColorSet.size();
        while (c2 < GREEN_COLORS.length) {
            int value = (c2 - startIndexBase) * GREEN_COLORS.length / (GREEN_COLORS.length - startIndexBase);
            ImageWriterUtil.GREEN_COLORS[c2] = new RGB(value, value, value);
            ++c2;
        }
        GREEN_COLOR_BACKGROUND = ImageWriterUtil.getPaletteIndex(255, 255, 255, GREEN_COLORS);
    }

    private ImageWriterUtil() {
    }

    public static void writeFigureToDeviceContext(IFigure figure, Drawable dest, int format, RGB backgroundColor) {
        SWTGraphics destGraphics = new SWTGraphics(new GC(dest));
        figure.setBackgroundColor(new Color(null, backgroundColor));
        destGraphics.translate(figure.getBounds().getTopLeft().negate());
        figure.paint((Graphics)destGraphics);
    }

    public static void writeFigureToLoader(IFigure figure, ImageLoader imageIO, int format) {
        ImageWriterUtil.writeFigureToLoader(figure, imageIO, format, GREEN_COLORS[GREEN_COLOR_BACKGROUND]);
    }

    public static void writeFigureToLoader(IFigure figure, ImageLoader imageIO, int format, RGB backgroundColor) {
        org.eclipse.draw2d.geometry.Rectangle figureBounds = figure.getBounds();
        imageIO.logicalScreenWidth = figureBounds.width;
        imageIO.logicalScreenHeight = figureBounds.height;
        Image destImage = new Image(null, figureBounds.width, figureBounds.height);
        ImageWriterUtil.writeFigureToDeviceContext(figure, (Drawable)destImage, format, backgroundColor);
        if (format == 2) {
            ImageData destImageData = ImageWriterUtil.getImageDataInEightBitColor(destImage.getImageData());
            imageIO.data = new ImageData[]{destImageData};
            imageIO.backgroundPixel = GREEN_COLOR_BACKGROUND;
        } else {
            imageIO.data = new ImageData[]{destImage.getImageData()};
        }
        imageIO.repeatCount = 0;
    }

    public static void writeImageToLoader(Image image, ImageLoader imageIO, int format) {
        ImageWriterUtil.writeImageToLoader(image, imageIO, format, -1);
    }

    public static void writeImageToLoader(Image image, ImageLoader imageIO, int format, int backgroundColorIndex) {
        Rectangle imageBounds = image.getBounds();
        imageIO.logicalScreenWidth = imageBounds.width;
        imageIO.logicalScreenHeight = imageBounds.height;
        if (format == 2) {
            ImageData imageData = ImageWriterUtil.getImageDataInEightBitColor(image.getImageData());
            imageIO.data = new ImageData[]{imageData};
            imageIO.backgroundPixel = backgroundColorIndex;
        } else {
            imageIO.data = new ImageData[]{image.getImageData()};
        }
        imageIO.repeatCount = 0;
    }

    protected static ImageData getImageDataInEightBitColor(ImageData destImageData) {
        ImageData destImageDataGrayscale = new ImageData(destImageData.width, destImageData.height, 8, new PaletteData(GREEN_COLORS));
        HashMap<String, Integer> colorIndexCache = new HashMap<String, Integer>();
        int y = 0;
        while (y < destImageData.height) {
            int scanlineBegin = y * destImageData.bytesPerLine;
            int scanlineBeginGrayscale = y * destImageDataGrayscale.bytesPerLine;
            int x = 0;
            while (x < destImageData.width) {
                int offset = scanlineBegin + x * 3;
                int offsetGrayscale = scanlineBeginGrayscale + x;
                int red = destImageData.data[offset] & 0xFF;
                int green = destImageData.data[offset + 1] & 0xFF;
                int blue = destImageData.data[offset + 2] & 0xFF;
                String key = String.valueOf(red) + "/" + green + "/" + blue;
                Integer index = (Integer)colorIndexCache.get(key);
                if (index == null) {
                    int index2 = ImageWriterUtil.getPaletteIndex(red, green, blue, destImageDataGrayscale.getRGBs());
                    destImageDataGrayscale.data[offsetGrayscale] = (byte)index2;
                    colorIndexCache.put(key, new Integer(index2));
                } else {
                    destImageDataGrayscale.data[offsetGrayscale] = (byte)index.intValue();
                }
                ++x;
            }
            ++y;
        }
        return destImageDataGrayscale;
    }

    public static int getPaletteIndex(int color, RGB[] colorPalette) {
        return ImageWriterUtil.getPaletteIndex(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, colorPalette);
    }

    public static int getPaletteIndex(int r, int g, int b, RGB[] colorPalette) {
        int minDifference = 768;
        int indexMinDiff = -1;
        int c = 0;
        while (c < colorPalette.length) {
            int difference = Math.abs(colorPalette[c].red - r) + Math.abs(colorPalette[c].green - g) + Math.abs(colorPalette[c].blue - b);
            if (difference < minDifference) {
                indexMinDiff = c;
                minDifference = difference;
                if (difference == 0) break;
            }
            ++c;
        }
        return indexMinDiff;
    }

    private static RGB getRGB(Color color) {
        return new RGB(color.getRed(), color.getGreen(), color.getBlue());
    }
}

