/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green;

import edu.buffalo.cse.green.CompilationUnitRefactorHandler;
import edu.buffalo.cse.green.FieldRefactorHandler;
import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.MethodRefactorHandler;
import edu.buffalo.cse.green.PackageRefactorHandler;
import edu.buffalo.cse.green.ProjectRefactorHandler;
import edu.buffalo.cse.green.RefactorHandler;
import edu.buffalo.cse.green.TypeRefactorHandler;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.FieldPart;
import edu.buffalo.cse.green.editor.controller.MethodPart;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.model.AbstractModel;
import edu.buffalo.cse.green.editor.model.FieldModel;
import edu.buffalo.cse.green.editor.model.MethodModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModelListener
implements IElementChangedListener {
    private static JavaModelListener _listener = new JavaModelListener();
    private static Map<Class, RefactorHandler> map = new HashMap<Class, RefactorHandler>();

    static {
        map.put(JavaProject.class, ProjectRefactorHandler.instance());
        map.put(PackageFragment.class, PackageRefactorHandler.instance());
        map.put(CompilationUnit.class, CompilationUnitRefactorHandler.instance());
        map.put(SourceType.class, TypeRefactorHandler.instance());
        map.put(SourceField.class, FieldRefactorHandler.instance());
        map.put(SourceMethod.class, MethodRefactorHandler.instance());
    }

    private JavaModelListener() {
    }

    public static JavaModelListener getListener() {
        return _listener;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            try {
                for (Class type : map.keySet()) {
                    List<IJavaElementDelta> added = this.findAddedElements(event.getDelta(), type);
                    List<IJavaElementDelta> removed = this.findRemovedElements(event.getDelta(), type);
                    List<IJavaElementDelta> changed = this.findChangedElements(event.getDelta(), type);
                    HashMap<IJavaElement, IJavaElement> moved = this.extractMovedElements(added, removed);
                    if (added.size() == 0 && removed.size() == 0 && moved.size() == 0 && changed.size() == 0) continue;
                    ArrayList<DiagramEditor> editors = new ArrayList<DiagramEditor>(DiagramEditor.getEditors());
                    for (DiagramEditor editor : editors) {
                        RootModel root = editor.getRootModel();
                        for (IJavaElement sourceElement : moved.keySet()) {
                            IJavaElement targetElement = moved.get(sourceElement);
                            map.get(sourceElement.getClass()).handleMove(root, sourceElement, targetElement);
                        }
                        for (IJavaElementDelta removedElement : removed) {
                            map.get(removedElement.getElement().getClass()).handleRemove(root, removedElement.getElement());
                        }
                        for (IJavaElementDelta addedElement : added) {
                            map.get(addedElement.getElement().getClass()).handleAdd(root, addedElement.getElement());
                        }
                        for (IJavaElementDelta changedElement : changed) {
                            this.handleElementChange(changedElement);
                        }
                    }
                }
            }
            catch (Throwable t) {
                GreenException.critical(t);
            }
        }
        finally {
            TypeRefactorHandler.REMOVED_TYPE = null;
        }
    }

    private HashMap<IJavaElement, IJavaElement> extractMovedElements(List<IJavaElementDelta> added, List<IJavaElementDelta> removed) {
        HashMap<IJavaElement, IJavaElement> moved = new HashMap<IJavaElement, IJavaElement>();
        ArrayList<IJavaElementDelta> notAdded = new ArrayList<IJavaElementDelta>();
        ArrayList<IJavaElementDelta> notRemoved = new ArrayList<IJavaElementDelta>();
        for (IJavaElementDelta toDelta : added) {
            if (toDelta.getMovedFromElement() == null) continue;
            IJavaElement newElement = toDelta.getElement();
            for (IJavaElementDelta fromDelta : removed) {
                if (!JavaModelListener.sameElements(fromDelta.getMovedToElement(), newElement)) continue;
                IJavaElement oldElement = fromDelta.getElement();
                if (!JavaModelListener.sameElements(toDelta.getMovedFromElement(), oldElement)) continue;
                moved.put(oldElement, newElement);
                notAdded.add(toDelta);
                notRemoved.add(fromDelta);
            }
        }
        added.removeAll(notAdded);
        removed.removeAll(notRemoved);
        return moved;
    }

    private List<IJavaElementDelta> findAddedElements(IJavaElementDelta parentDelta, Class type) {
        ArrayList<IJavaElementDelta> changes = new ArrayList<IJavaElementDelta>();
        if (parentDelta.getKind() == 1 && type.isInstance(parentDelta.getElement())) {
            changes.add(parentDelta);
        }
        IJavaElementDelta[] iJavaElementDeltaArray = parentDelta.getAffectedChildren();
        int n = 0;
        int n2 = iJavaElementDeltaArray.length;
        while (n < n2) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n];
            changes.addAll(this.findAddedElements(delta, type));
            ++n;
        }
        return changes;
    }

    private List<IJavaElementDelta> findChangedElements(IJavaElementDelta parentDelta, Class type) {
        IJavaElementDelta delta;
        ArrayList<IJavaElementDelta> changes = new ArrayList<IJavaElementDelta>();
        int i = 0;
        while (i < parentDelta.getChangedChildren().length) {
            delta = parentDelta.getChangedChildren()[i];
            if (type.isInstance(delta.getElement()) && delta.getChangedChildren().length == 0) {
                changes.add(delta);
            }
            ++i;
        }
        i = 0;
        while (i < parentDelta.getChangedChildren().length) {
            delta = parentDelta.getChangedChildren()[i];
            changes.addAll(this.findChangedElements(delta, type));
            ++i;
        }
        return changes;
    }

    private List<IJavaElementDelta> findRemovedElements(IJavaElementDelta parentDelta, Class type) {
        ArrayList<IJavaElementDelta> changes = new ArrayList<IJavaElementDelta>();
        if (parentDelta.getKind() == 2 && type.isInstance(parentDelta.getElement())) {
            changes.add(parentDelta);
        }
        IJavaElementDelta[] iJavaElementDeltaArray = parentDelta.getAffectedChildren();
        int n = 0;
        int n2 = iJavaElementDeltaArray.length;
        while (n < n2) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n];
            changes.addAll(this.findRemovedElements(delta, type));
            ++n;
        }
        return changes;
    }

    private void handleElementChange(IJavaElementDelta elementDelta) {
        IJavaElement element = elementDelta.getElement();
        if ((elementDelta.getFlags() & 2) != 0) {
            for (DiagramEditor editor : DiagramEditor.getEditors()) {
                RootPart rootEditPart = editor.getRootPart();
                RootModel root = (RootModel)rootEditPart.getModel();
                AbstractModel abstractModel = root.getModelFromElement(element);
                if (abstractModel == null) continue;
                if (abstractModel instanceof FieldModel) {
                    FieldModel fModel = (FieldModel)abstractModel;
                    FieldPart fEditPart = (FieldPart)rootEditPart.getPartFromModel(fModel);
                    fEditPart.updateIcon();
                    continue;
                }
                if (!(abstractModel instanceof MethodModel)) continue;
                MethodModel mModel = (MethodModel)abstractModel;
                MethodPart mEditPart = (MethodPart)rootEditPart.getPartFromModel(mModel);
                mEditPart.updateIcon();
            }
        }
    }

    public static boolean sameElements(IJavaElement e1, IJavaElement e2) {
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.getHandleIdentifier().equals(e2.getHandleIdentifier());
    }
}

