/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.GreenEditorInput;
import edu.buffalo.cse.green.editor.model.NoteModel;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.RootModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.save.ISaveFormat;
import edu.buffalo.cse.green.relationships.RelationshipCache;
import edu.buffalo.cse.green.xml.XMLConverter;
import edu.buffalo.cse.green.xml.XMLNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

class DiagramEditorFilePolicies {
    DiagramEditorFilePolicies() {
    }

    private static void displayInvalidFileFormatError(File file) {
        GreenException.fileException("Invalid file format");
    }

    private static IType extractType(String projectName, String fullyQualifiedTypeName) {
        try {
            IJavaModel jm = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            return jm.getJavaProject(projectName).findType(fullyQualifiedTypeName);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IType extractType(String handleId) {
        IType type = (IType)JavaCore.create((String)handleId);
        if (type.exists()) {
            return type;
        }
        return null;
    }

    public static void load(final DiagramEditor editor, File file) {
        XMLConverter converter = new XMLConverter();
        char[] fileContents = new char[(int)file.length()];
        try {
            FileReader fReader = null;
            try {
                fReader = new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                GreenException.warn("The file " + file + " was not found.");
                return;
            }
            fReader.read(fileContents);
            fReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (fileContents.length < 5) {
            return;
        }
        XMLNode node = converter.getDecodedXML(new String(fileContents));
        if (!node.getName().equals("!root")) {
            DiagramEditorFilePolicies.displayInvalidFileFormatError(file);
            return;
        }
        if (node.getChildren().size() == 0) {
            return;
        }
        final XMLNode parent = node.getChild("uml");
        PlugIn.runWithoutRecognizers(new Runnable(){

            public void run() {
                DiagramEditorFilePolicies.load(editor, parent);
            }
        });
    }

    public static void save(DiagramEditor editor, boolean askForName) {
        String extension;
        ISaveFormat format;
        Path filePath = new Path("/noname");
        if (editor.getEditorInput() instanceof GreenEditorInput) {
            GreenEditorInput input = (GreenEditorInput)editor.getEditorInput();
            filePath = new Path(input.getPath().toFile().toString());
        }
        if (editor.getCurrentFile() != null) {
            filePath = PlugIn.getWorkspaceRoot().getFile(editor.getCurrentFile().getFullPath()).getLocation();
        }
        if (askForName || !filePath.toFile().exists()) {
            String fileName = filePath.toString();
            FileDialog dialog = new FileDialog(editor.getSite().getShell(), 8192);
            dialog.setFileName(fileName.substring(fileName.lastIndexOf(47)));
            ArrayList<String> fExt = new ArrayList<String>();
            ArrayList<String> fDesc = new ArrayList<String>();
            for (String ext : PlugIn.getSaveFormats()) {
                String sExt = "*." + ext;
                ISaveFormat format2 = PlugIn.getSaveFormat(ext);
                String desc = format2.getDescription();
                if (desc == "null") {
                    desc = "";
                }
                fExt.add(sExt);
                fDesc.add(String.valueOf(format2.getDescription()) + " (" + sExt + ")");
            }
            dialog.setFilterExtensions(fExt.toArray(new String[0]));
            dialog.setFilterNames(fDesc.toArray(new String[0]));
            dialog.setFilterPath(filePath.toOSString());
            fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            filePath = new Path(fileName);
            String workspaceString = PlugIn.getWorkspaceRoot().getLocation().toPortableString();
            String workspaceDir = String.valueOf(workspaceString.substring(workspaceString.lastIndexOf(47))) + "/";
            String fileLocation = filePath.toPortableString();
            int wsIndex = fileLocation.indexOf(workspaceDir);
            if (wsIndex == -1) {
                try {
                    filePath.toFile().createNewFile();
                }
                catch (IOException e) {
                    GreenException.fileException("There was a problem accessing \"" + filePath + "\"");
                    e.printStackTrace();
                    return;
                }
                if (filePath.toString().endsWith(".dia")) {
                    editor.setEditorInput(new GreenEditorInput(new File(filePath.toOSString())));
                }
            } else {
                String wsFile = fileLocation.substring(wsIndex + workspaceDir.length());
                String wsProject = wsFile.substring(0, wsFile.indexOf(47));
                try {
                    IProject project = PlugIn.getWorkspaceRoot().getProject(wsProject);
                    IFile file = DiagramEditor.getFileNotExist(project, (IPath)new Path(wsFile));
                    if (file.toString().endsWith(".dia")) {
                        editor.setEditorInput((IEditorInput)new FileEditorInput(file));
                    }
                    filePath = PlugIn.getWorkspaceRoot().getFile(editor.getCurrentFile().getFullPath()).getLocation();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        if ((format = PlugIn.getSaveFormat(extension = filePath.getFileExtension())) == null) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Invalid file format", (String)("Invalid file format: " + extension));
            return;
        }
        format.saveInformation(editor, filePath.toOSString(), editor.getRootPart().getFigure());
    }

    private static void load(DiagramEditor editor, XMLNode base) {
        int fileVersion;
        RootModel root = editor.getRootModel();
        String version = base.getAttribute("greenVersion");
        int pluginVersion = PlugIn.getVersion();
        int n = fileVersion = version == null ? 20000 : Integer.parseInt(version);
        if (pluginVersion < fileVersion) {
            MessageDialog.openWarning((Shell)editor.getSite().getShell(), (String)"File newer than plugin.", (String)GreenException.generateVersionWarning(pluginVersion, fileVersion));
            fileVersion = pluginVersion;
        }
        DiagramEditorFilePolicies.loadTypes(root, base, fileVersion);
        DiagramEditorFilePolicies.loadNotes(root, base, fileVersion);
        DiagramEditorFilePolicies.loadRelat(editor, root, base, fileVersion);
    }

    private static void loadTypes(RootModel root, XMLNode base, int ver) {
        if (ver == 20000) {
            for (XMLNode child : base.getChildren()) {
                if (!child.getName().equals("type")) continue;
                String proj = child.getAttribute("project");
                String fqn = child.getAttribute("name");
                int height = child.getIntAttribute("height");
                int width = child.getIntAttribute("width");
                int x = child.getIntAttribute("x");
                int y = child.getIntAttribute("y");
                IType type = DiagramEditorFilePolicies.extractType(proj, fqn);
                if (type == null) {
                    GreenException.warn("Type does not exist: " + fqn);
                    continue;
                }
                TypeModel model = root.createTypeModel(type);
                model.setLocation(new Point(x, y));
                model.setSize(new Dimension(width, height));
            }
        } else if (ver <= 30000) {
            for (XMLNode child : base.getChildren()) {
                if (!child.getName().equals("type")) continue;
                String handle = child.getAttribute("name");
                int height = child.getIntAttribute("height");
                int width = child.getIntAttribute("width");
                int x = child.getIntAttribute("x");
                int y = child.getIntAttribute("y");
                IType type = DiagramEditorFilePolicies.extractType(handle);
                if (type == null) {
                    GreenException.warn("Type does not exist: " + handle);
                    continue;
                }
                TypeModel model = root.createTypeModel(type);
                model.setLocation(new Point(x, y));
                model.setSize(new Dimension(width, height));
            }
        } else {
            GreenException.warn("loadTypes failed: invalid file version: " + ver);
        }
    }

    private static void loadRelat(DiagramEditor editor, RootModel root, XMLNode base, int ver) {
        editor.refresh(true);
        RelationshipCache cache = root.getRelationshipCache();
        if (ver == 20000) {
            for (XMLNode relationshipNode : base.getChildren()) {
                IType targettype;
                if (!relationshipNode.getName().equals("relationship")) continue;
                String relationshipClass = relationshipNode.getAttribute("class");
                String sourceProj = relationshipNode.getAttribute("sourceProject");
                String sourceName = relationshipNode.getAttribute("sourceType");
                String targetProj = relationshipNode.getAttribute("targetProject");
                String targetName = relationshipNode.getAttribute("targetType");
                IType sourcetype = DiagramEditorFilePolicies.extractType(sourceProj, sourceName);
                RelationshipModel rModel = cache.getRelationshipModel(sourcetype, targettype = DiagramEditorFilePolicies.extractType(targetProj, targetName), relationshipClass);
                if (rModel == null) continue;
                XMLNode bendpointsNode = relationshipNode.getChild("bendpoints");
                for (XMLNode bendpointNode : bendpointsNode.getChildren()) {
                    if (!bendpointNode.getName().equals("bendpoint")) continue;
                    int x = new Integer(bendpointNode.getAttribute("x"));
                    int y = new Integer(bendpointNode.getAttribute("y"));
                    editor.addBendpoint(rModel, new Point(x, y));
                }
            }
        } else if (ver <= 30000) {
            for (XMLNode relationshipNode : base.getChildren()) {
                IType targettype;
                if (!relationshipNode.getName().equals("relationship")) continue;
                String relationshipClass = relationshipNode.getAttribute("class");
                String sourceId = relationshipNode.getAttribute("sourceType");
                String targetId = relationshipNode.getAttribute("targetType");
                IType sourcetype = DiagramEditorFilePolicies.extractType(sourceId);
                RelationshipModel rModel = cache.getRelationshipModel(sourcetype, targettype = DiagramEditorFilePolicies.extractType(targetId), relationshipClass);
                if (rModel == null) continue;
                XMLNode bendpointsNode = relationshipNode.getChild("bendpoints");
                for (XMLNode bendpointNode : bendpointsNode.getChildren()) {
                    if (!bendpointNode.getName().equals("bendpoint")) continue;
                    int x = new Integer(bendpointNode.getAttribute("x"));
                    int y = new Integer(bendpointNode.getAttribute("y"));
                    editor.addBendpoint(rModel, new Point(x, y));
                }
            }
        } else {
            GreenException.warn("loadRelat failed: invalid file version: " + ver);
        }
    }

    private static void loadNotes(RootModel root, XMLNode base, int ver) {
        if (ver <= 30000) {
            for (XMLNode child : base.getChildren()) {
                if (!child.getName().equals("note")) continue;
                String text = child.getAttribute("text");
                int height = child.getIntAttribute("height");
                int width = child.getIntAttribute("width");
                int x = child.getIntAttribute("x");
                int y = child.getIntAttribute("y");
                NoteModel model = new NoteModel();
                model.setLabel(text);
                model.setLocation(new Point(x, y));
                model.setSize(new Dimension(width, height));
                root.addChild(model);
            }
        } else {
            GreenException.warn("loadNotes failed: invalid file version: " + ver);
        }
    }
}

