/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.JavadocGrabber;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.model.MemberModel;
import edu.buffalo.cse.green.editor.view.IIconHolder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.swt.widgets.Display;

public abstract class MemberPart
extends AbstractPart {
    protected abstract IIconHolder getNameLabel();

    private IIconHolder figure() {
        return (IIconHolder)this.getFigure();
    }

    protected void addPropertyListeners() {
        this.addListener(PropertyChange.Element, new AbstractPart.VisualsUpdater());
    }

    private String getJavaDoc() {
        Object element = this.model().getJavaElement();
        int type = element.isBinary() ? 6 : 5;
        CompilationUnit cu = this.getEditor().getCompilationUnit(element.getAncestor(type));
        JavadocGrabber grabber = this.getJavadocGrabber();
        grabber.setElement((IJavaElement)this.model().getMember());
        cu.accept((ASTVisitor)grabber);
        return grabber.getJavadoc();
    }

    protected abstract JavadocGrabber getJavadocGrabber();

    public void deactivate() {
        this.deactivate(this.figure().shouldDisposeFont());
    }

    protected void deactivate(boolean removeIcon) {
        if (removeIcon) {
            this.figure().getIcon().dispose();
        }
        super.deactivate();
    }

    protected void refreshVisuals() {
        this.updateFont();
        this.updateIcon();
        this.updateLabel();
        this.updateVisibility();
    }

    private void updateVisibility() {
        try {
            if (this.getEditor().isFiltered((IMember)this.model().getMember())) {
                this.model().setVisible(false);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public abstract void updateFont();

    public abstract void updateIcon();

    public abstract void updateLabel();

    protected void repaintLabel(final IIconHolder label) {
        if (Display.getCurrent() != null) {
            label.setText(this.model().getDisplayName());
            label.repaint();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    label.setText(MemberPart.this.model().getDisplayName());
                    label.repaint();
                }
            });
        }
    }

    private MemberModel model() {
        return (MemberModel)this.getModel();
    }

    public void setInitialBackgroundColor() {
        this.getFigure().setBackgroundColor(PlugIn.getColorPreference("color.uml"));
    }

    public void initialize() {
        this.getNameLabel().addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                if (!PlugIn.getBooleanPreference("display.element.tooltips")) {
                    return;
                }
                String doc = MemberPart.this.getJavaDoc().trim();
                MemberPart.this.getViewer().getControl().setToolTipText(doc);
            }

            public void mouseExited(MouseEvent me) {
                MemberPart.this.getViewer().getControl().setToolTipText(null);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    protected String getDoc(Javadoc doc) {
        if (doc == null) {
            return "";
        }
        return doc.toString();
    }
}

