/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.action.EditNoteAction;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.policies.GreenSelectionEditPolicy;
import edu.buffalo.cse.green.editor.model.NoteModel;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteNoteCommand;
import edu.buffalo.cse.green.editor.view.INoteFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

public class NotePart
extends AbstractPart {
    protected IFigure doCreateFigure() {
        INoteFigure label = (INoteFigure)this.generateFigure();
        label.setLocation(this.model().getLocation());
        label.setSize(this.model().getSize());
        label.setText(this.model().getLabel());
        return label;
    }

    protected void refreshVisuals() {
        Point loc = ((NoteModel)this.getModel()).getLocation();
        Dimension size = ((NoteModel)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        this.figure().setText(((NoteModel)this.getModel()).getLabel());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new GreenSelectionEditPolicy());
    }

    public DeleteCommand getDeleteCommand() {
        return new DeleteNoteCommand((NoteModel)this.getModel());
    }

    protected void addPropertyListeners() {
        this.addListener(PropertyChange.Location, new AbstractPart.VisualsUpdater());
        this.addListener(PropertyChange.Note, new AbstractPart.VisualsUpdater());
        this.addListener(PropertyChange.Size, new AbstractPart.VisualsUpdater());
    }

    protected void onDoubleClick() {
        EditNoteAction action = new EditNoteAction();
        action.setSelectionProvider(this.getEditor());
        action.run();
    }

    private INoteFigure figure() {
        return (INoteFigure)this.getFigure();
    }

    private NoteModel model() {
        return (NoteModel)this.getModel();
    }

    protected void updateColors(IFigure f) {
        f.setBorder((Border)new LineBorder(PlugIn.getColorPreference("color.note.border"), 2));
        f.setBackgroundColor(PlugIn.getColorPreference("color.note"));
        f.setForegroundColor(PlugIn.getColorPreference("color.note.text"));
    }

    public void setInitialBackgroundColor() {
        this.getFigure().setBackgroundColor(PlugIn.getColorPreference("color.note"));
    }
}

