/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.editor.controller;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.PlugIn;
import edu.buffalo.cse.green.editor.DiagramEditor;
import edu.buffalo.cse.green.editor.controller.AbstractPart;
import edu.buffalo.cse.green.editor.controller.PropertyChange;
import edu.buffalo.cse.green.editor.controller.PropertyListener;
import edu.buffalo.cse.green.editor.controller.RootPart;
import edu.buffalo.cse.green.editor.controller.policies.BendableRelationshipEditPolicy;
import edu.buffalo.cse.green.editor.controller.policies.RelationshipLayoutEditPolicy;
import edu.buffalo.cse.green.editor.controller.policies.RelationshipSelectionEditPolicy;
import edu.buffalo.cse.green.editor.model.RelationshipModel;
import edu.buffalo.cse.green.editor.model.TypeModel;
import edu.buffalo.cse.green.editor.model.commands.CreateBendpointCommand;
import edu.buffalo.cse.green.editor.model.commands.DeleteCommand;
import edu.buffalo.cse.green.editor.view.GreenBendpoint;
import edu.buffalo.cse.green.editor.view.RelationshipFigure;
import edu.buffalo.cse.green.relationships.RelationshipGroup;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public abstract class RelationshipPart
extends AbstractPart
implements ConnectionEditPart,
PropertyChangeListener,
RelationshipFigure.RelationshipFigureListener {
    private int _loopSize = 40;
    private RootPart _root;
    private Label _sourceMultiplicityLabel;
    private RotatableDecoration _sourceDecoration;
    private RotatableDecoration _targetDecoration;
    private boolean _ignoreNextUpdateRequest;

    protected final IFigure doCreateFigure() {
        RelationshipFigure rFigure = this.createConnection();
        this.model().getSourceModel().getOutgoingEdges().add(this.model());
        this.model().getTargetModel().getIncomingEdges().add(this.model());
        rFigure.setConnectionRouter(DiagramEditor.getConnectionRouter());
        TypeModel modelSource = this.model().getSourceModel();
        TypeModel modelTarget = this.model().getTargetModel();
        if (modelSource != null && modelTarget != null) {
            this._sourceDecoration = this.createSourceArrow();
            this._targetDecoration = this.createTargetArrow();
            rFigure.setSourceDecoration(this._sourceDecoration);
            rFigure.setTargetDecoration(this._targetDecoration);
            ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator((Connection)rFigure, false);
            sourceEndpointLocator.setVDistance(15);
            this._sourceMultiplicityLabel = new Label();
            this._sourceMultiplicityLabel.setFont(PlugIn.getFontPreference("font", false, false));
            rFigure.add((IFigure)this._sourceMultiplicityLabel, sourceEndpointLocator);
        }
        rFigure.setLineWidth(1);
        rFigure.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                if (!RelationshipPart.this.model().getBounds().equals((Object)source.getBounds())) {
                    RelationshipPart.this.model().setBounds(source.getBounds());
                }
            }
        });
        return rFigure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new RelationshipSelectionEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new BendableRelationshipEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RelationshipLayoutEditPolicy());
    }

    public void activate() {
        if (this.getParent() != null) {
            super.activate();
            this._root = this.getRootPart();
            this.updateSourceAnchor();
            this.updateTargetAnchor();
            if (this.model().getSourceModel().equals(this.model().getTargetModel())) {
                this.createLoop();
            }
        }
    }

    public abstract RelationshipFigure createConnection();

    public abstract RotatableDecoration createSourceArrow();

    public abstract RotatableDecoration createTargetArrow();

    public DeleteCommand getDeleteCommand() {
        return this.model().getDeleteCommand(this.getEditor());
    }

    public EditPart getSource() {
        return this._root.getPartFromModel(this.model().getSourceModel());
    }

    public EditPart getTarget() {
        return this._root.getPartFromModel(this.model().getTargetModel());
    }

    public void setSource(EditPart source) {
        this.updateSourceAnchor();
    }

    public void setTarget(EditPart target) {
        this.updateTargetAnchor();
    }

    protected void updateSourceAnchor() {
        NodeEditPart part = (NodeEditPart)this.getSource();
        if (this.isActive()) {
            this.figure().setSourceAnchor(part.getSourceConnectionAnchor((ConnectionEditPart)this));
        }
    }

    protected void updateTargetAnchor() {
        NodeEditPart part = (NodeEditPart)this.getTarget();
        if (this.isActive()) {
            this.figure().setTargetAnchor(part.getTargetConnectionAnchor((ConnectionEditPart)this));
        }
    }

    public void relationshipFigureMoved(RelationshipFigure movedFigure) {
        this.updateChildren();
    }

    public void relationshipFigureWasAdded(RelationshipFigure addedFigure) {
        List<GreenBendpoint> bendpoints = this.model().getBendpointList();
        if (bendpoints == null) {
            bendpoints = new ArrayList<GreenBendpoint>();
            this.model().setBendpointList(bendpoints);
        }
        DiagramEditor.getConnectionRouter().setConstraint((Connection)this.getFigure(), bendpoints);
    }

    public void relationshipFigureWasRemoved(RelationshipFigure removedFigure) {
    }

    public void createLoop() {
        final RelationshipModel rModel = (RelationshipModel)this.getModel();
        RelationshipFigure rFigure = (RelationshipFigure)this.getFigure();
        rFigure.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        int x = 0;
        while (x < 3) {
            BendpointRequest request = new BendpointRequest();
            request.setIndex(x);
            request.setSource((ConnectionEditPart)this);
            switch (x) {
                case 0: {
                    request.setLocation(new Point(this._loopSize, 0));
                    break;
                }
                case 1: {
                    request.setLocation(new Point(this._loopSize, -this._loopSize));
                    break;
                }
                case 2: {
                    request.setLocation(new Point(0, -this._loopSize));
                    break;
                }
                default: {
                    GreenException.illegalOperation("Invalid index");
                }
            }
            new CreateBendpointCommand(rFigure, request).execute();
            ++x;
        }
        rFigure.setRecursive(this.getPartFromModel(rModel.getSourceModel()).getFigure());
        rModel.getSourceModel().addListener(PropertyChange.Size, new PropertyListener(){
            private Dimension _oldSize;
            {
                this._oldSize = relationshipModel.getSourceModel().getSize();
            }

            public void notify(Object oValue, Object nValue) {
                Dimension newSize = rModel.getSourceModel().getSize();
                Dimension delta = newSize.getExpanded(this._oldSize.getNegated()).getScaled(0.5);
                delta.height = -delta.height;
                this._oldSize = newSize;
            }
        });
    }

    protected void addPropertyListeners() {
        this.addListener(PropertyChange.RelationshipSource, new RelationshipSourceHandler());
        this.addListener(PropertyChange.RelationshipTarget, new RelationshipTargetHandler());
        this.addListener(PropertyChange.RelationshipCardinality, new RelationshipCardinalityHandler());
    }

    protected void onDoubleClick() {
    }

    protected void updateColors(IFigure f) {
        Color fillColor = PlugIn.getColorPreference("color.rel.arrow.fill");
        Color lineColor = PlugIn.getColorPreference("color.rel.line");
        this._sourceMultiplicityLabel.setForegroundColor(PlugIn.getColorPreference("color.rel.text"));
        f.setForegroundColor(lineColor);
        if (this._sourceDecoration != null) {
            this._sourceDecoration.setBackgroundColor(fillColor);
            this._sourceDecoration.setForegroundColor(lineColor);
        }
        if (this._targetDecoration != null) {
            this._targetDecoration.setBackgroundColor(fillColor);
            this._targetDecoration.setForegroundColor(lineColor);
        }
    }

    private void updateCardinalityLabel() {
        try {
            String cardinality = this.model().getCardinality();
            if (cardinality.equals("1")) {
                cardinality = "";
            }
            this._sourceMultiplicityLabel.setText(String.valueOf(cardinality) + this.subtypeLabel());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    protected void refreshVisuals() {
        this.updateCardinalityLabel();
        this.updateFont();
        ConnectionRouter desiredRouter = DiagramEditor.getConnectionRouter();
        if (!this.figure().isRecursive() && !this.figure().getConnectionRouter().getClass().equals(desiredRouter.getClass())) {
            this.figure().setConnectionRouter(desiredRouter);
        }
        this.figure().setLineWidth(PlugIn.getIntegerPreference("draw.line.width"));
    }

    private void updateFont() {
        if (Display.getCurrent() != null) {
            this.updateFontHelper();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RelationshipPart.this.updateFontHelper();
                }
            });
        }
    }

    private void updateFontHelper() {
        if (this._ignoreNextUpdateRequest) {
            this._ignoreNextUpdateRequest = false;
            return;
        }
        this._ignoreNextUpdateRequest = true;
        Font font = this._sourceMultiplicityLabel.getFont();
        font.dispose();
        this._sourceMultiplicityLabel.setFont(PlugIn.getFontPreference("font", false, false));
    }

    private RelationshipFigure figure() {
        return (RelationshipFigure)this.getFigure();
    }

    public EditPolicy generateResizableEditPolicy() {
        NonResizableEditPolicy dragPolicy = new NonResizableEditPolicy();
        dragPolicy.setDragAllowed(false);
        return dragPolicy;
    }

    public void setSelectedBackgroundColor() {
        this.getFigure().setBorder((Border)new LineBorder(PlugIn.getColorPreference("color.rel.line"), 1));
    }

    public void setInitialBackgroundColor() {
    }

    private String subtypeLabel() {
        if (!PlugIn.getBooleanPreference("display.relationship.subtypes")) {
            return "";
        }
        RelationshipGroup group = PlugIn.getRelationshipGroup(this.getClass());
        if (group.getSubtype() == null) {
            return "";
        }
        return " <<" + group.getSubtype() + ">>";
    }

    private RelationshipModel model() {
        return (RelationshipModel)this.getModel();
    }

    class RelationshipCardinalityHandler
    implements PropertyListener {
        RelationshipCardinalityHandler() {
        }

        public void notify(Object oValue, Object nValue) {
            RelationshipPart.this.updateCardinalityLabel();
            RelationshipPart.this.updateChildren();
        }
    }

    class RelationshipSourceHandler
    implements PropertyListener {
        RelationshipSourceHandler() {
        }

        public void notify(Object oValue, Object nValue) {
            RootPart rootPart = RelationshipPart.this.getRootPart();
            TypeModel oldModel = (TypeModel)oValue;
            TypeModel newModel = (TypeModel)nValue;
            if (oldModel != null) {
                oldModel.getOutgoingEdges().remove(RelationshipPart.this.getModel());
            }
            newModel.getOutgoingEdges().add(RelationshipPart.this.model());
            RelationshipPart.this.setSource((EditPart)rootPart.getPartFromModel(newModel));
            RelationshipPart.this.updateChildren();
        }
    }

    class RelationshipTargetHandler
    implements PropertyListener {
        RelationshipTargetHandler() {
        }

        public void notify(Object oValue, Object nValue) {
            RootPart rootPart = RelationshipPart.this.getRootPart();
            TypeModel oldModel = (TypeModel)oValue;
            TypeModel newModel = (TypeModel)nValue;
            if (oldModel != null) {
                oldModel.getIncomingEdges().remove(RelationshipPart.this.getModel());
            }
            newModel.getIncomingEdges().add(RelationshipPart.this.model());
            RelationshipPart.this.setTarget((EditPart)rootPart.getPartFromModel(newModel));
            RelationshipPart.this.updateChildren();
        }
    }
}

