/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.relationships;

import edu.buffalo.cse.green.GreenException;
import edu.buffalo.cse.green.editor.model.RelationshipKind;
import edu.buffalo.cse.green.relationships.Relationship;
import edu.buffalo.cse.green.relationships.RelationshipCache;
import edu.buffalo.cse.green.relationships.RelationshipVisitor;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipRecognizer
extends RelationshipVisitor {
    private RelationshipCache _cache;

    @Override
    public final void run(CompilationUnit cu, RelationshipCache cache) {
        this._cache = cache;
        try {
            cu.accept((ASTVisitor)this);
        }
        catch (RuntimeException runtimeException) {}
    }

    protected final void fireFoundRelationship(IType sourceType, ITypeBinding target, Class partClass, AbstractList<ASTNode> features) {
        IType targetType = (IType)target.getJavaElement();
        if (sourceType == null || target == null) {
            GreenException.illegalOperation("Cannot add a relationship that has a missing source/target type");
        }
        if (target.isParameterizedType()) {
            ITypeBinding[] iTypeBindingArray = target.getInterfaces();
            int n = 0;
            int n2 = iTypeBindingArray.length;
            while (n < n2) {
                ITypeBinding interfaceBinding = iTypeBindingArray[n];
                IType interfType = (IType)interfaceBinding.getJavaElement();
                if (interfType.getFullyQualifiedName().equals(Collection.class.getName())) {
                    IJavaElement element = target.getTypeArguments()[0].getJavaElement();
                    if (element.getElementType() == 7) {
                        targetType = (IType)element;
                    } else if (element.getElementType() == 15) {
                        targetType = (IType)target.getJavaElement();
                    }
                }
                ++n;
            }
        }
        this._cache.add(sourceType, targetType, partClass, new Relationship(features));
    }

    protected void processAddInvocations(List<ASTNode> features, Name variable, ASTNode node) {
        if (!(variable instanceof SimpleName)) {
            return;
        }
        Block block = null;
        while (node != null) {
            if (node.getNodeType() == 8) {
                block = (Block)node;
                break;
            }
            node = node.getParent();
        }
        for (Statement stmt : (AbstractList)block.statements()) {
            MethodInvocation m;
            ExpressionStatement eStmt;
            Expression e;
            if (stmt.getNodeType() != 21 || (e = (eStmt = (ExpressionStatement)stmt).getExpression()).getNodeType() != 32 || !((m = (MethodInvocation)e).getExpression() instanceof SimpleName)) continue;
            SimpleName name = (SimpleName)m.getExpression();
            SimpleName var = (SimpleName)variable;
            if (!name.getIdentifier().equals(var.getIdentifier()) || !m.getName().getIdentifier().equals("add")) continue;
            features.add((ASTNode)stmt);
        }
    }

    public abstract RelationshipKind getFlags();
}

