/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.green.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNode {
    private Map<String, String> _attributes = new HashMap<String, String>();
    private List<XMLNode> _children = new ArrayList<XMLNode>();
    private String _name = null;

    public XMLNode(String name) {
        this._name = name;
    }

    public List<XMLNode> getChildren() {
        return this._children;
    }

    public XMLNode getChild(String tagName) {
        for (XMLNode child : this._children) {
            if (!child.getName().equals(tagName)) continue;
            return child;
        }
        return null;
    }

    public void addChild(XMLNode node) {
        this._children.add(node);
    }

    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    public String getName() {
        return this._name;
    }

    public int getIntAttribute(String key) {
        return Integer.decode(this.getAttribute(key));
    }

    public String getAttribute(String key) {
        return this._attributes.get(key);
    }

    public String toString() {
        return this.recursiveToString(0);
    }

    private String recursiveToString(int level) {
        StringBuffer buf = new StringBuffer();
        int x = 0;
        while (x < level) {
            buf.append("   ");
            ++x;
        }
        buf.append(this._name);
        if (!this._attributes.toString().equals("{}")) {
            buf.append(" " + this._attributes);
        }
        for (XMLNode child : this._children) {
            buf.append(child.recursiveToString(level + 1));
        }
        return buf.toString();
    }
}

