import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)
import java.awt.Color;
import java.util.List;

/**
 * A ball is an object that can hit other objects and bounce off the 
 * edges of the world (except the bottom edge).  It will bounce off of
 * a paddle as well.
 * 
 * @author Barbara Ericson Georgia Tech 
 * @version 1.0 April 6, 2007
 */
public class Ball extends Actor
{

    //////////// fields /////////////////////////////
    
    /** the radius of this ball */
    private int radius = 10;
    
    /** the width of this ball (diameter) */
    private int width = radius * 2;
    
    /** the color of the ball */
    private Color color = Color.BLACK;
    
    /** the amount of change in x during each act */
    private int velX;
    
    /** the amount of change in y during each act */
    private int velY = 3;
    
    ////////////////// constructors /////////////////////
    
    /**
     * Constructor that takes no arguments 
     */
    public Ball()
    {
        velX = Greenfoot.getRandomNumber(2) + 2;
        if (Greenfoot.getRandomNumber(2) == 0)
           velX = -1 * velX;
        updateImage();
    }
    
    /**
     * Constructor that takes initial values for all fields
     * @param theRadius the radius to use
     * @param theColor  the color to use
     * @param theVelX   the amount to change in X per act
     * @param theVelY   the amount to change in Y per act
     */
    public Ball(int theRadius, Color theColor, int theVelX, int theVelY)
    {
        radius = theRadius;
        color = theColor;
        velX = theVelX;
        velY = theVelY;
        updateImage();
    }
    
    ///////////////////// Methods ///////////////////////////////
    
    /**
     * Balls will move and check if they have hit a brick or paddle or
     * one of the edges of the world
     */
    public void act() 
    {
        BreakoutWorld world = (BreakoutWorld) getWorld();
        
        // move the ball
        setLocation(getX() + velX, getY() + velY);
        
        // check if hit any object and it wasn't the message
        Actor actor = this.getOneIntersectingObject(Actor.class);
        if (actor != null && !(actor instanceof Message))
        {
            /* bounce off of the object */
            velY = -(velY + 2);
            
            /* if it was a brick then remove it and check if won */
            if (actor instanceof Brick)
            {
                world.removeObject(actor);
                world.checkIfWon();
            }
        }
        
        // check if hit walls
        if (getX() - radius <= 0) // left wall
           velX = -velX;
        else if (getX() + radius >= BreakoutWorld.WIDTH) // right wall
           velX = -velX;
        else if (getY() - radius <= 0) // top wall
           velY = -velY;
        else if (getY() + radius >= BreakoutWorld.HEIGHT) // bottom wall
        {
            world.removeObject(this);
            world.newBall();
        }
          
    }    
    
    /**
     * Method to create the image and set it for the ball 
     * If you change the ball width or color you should 
     * invoke this again
     */
    public void updateImage()
    {
        GreenfootImage image = new GreenfootImage(width,width);
        image.setColor(color);
        image.fillOval(0,0,width-1,width-1);
        setImage(image);
    }
}
