import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

public class Key extends Actor
{

    private boolean _isDown;
    private String _keyboardKey;
    private String _filename;
 
    /**
     * Create a new key.
     */
    public Key(String key, String file)
    {
        _isDown = false;
        _keyboardKey = key;
        _filename = file;
    }

    /**
     * Do the action for this key.
     */
    public void act()
    {
      if(!_isDown && Greenfoot.isKeyDown(_keyboardKey)) {
          setImage("white-key-down.png");
          play();
          _isDown = true;
      }   
      if(_isDown && !Greenfoot.isKeyDown(_keyboardKey)) {
          setImage("white-key.png");
          _isDown = false;
      }
    }
    
    public void play() {
        Greenfoot.playSound(_filename);
    }
    
   
}