import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * The BreakoutWorld class. A world for the game of breakout.
 * 
 * @author Adrienne Decker 
 */
public class BreakoutWorld  extends World
{

    /**
     * Constructor for objects of class MyWorld.
     * 
     */
    public BreakoutWorld()
    {    
        //The world is 500x500 cells
        super(500, 500, 1); 
        
        //Add the paddle to the world
        addObject(new Paddle(), 65, 475);
        
        //Call to method to add the bricks to the world
        addBricks();
        
        //Add the ball to the world - it sits on top of the paddle
        addObject(new Ball(), 68, 450);

    }
    
    /**
     * A method to add the bricks to the world.  There are 6 rows and 10 columns of
     * bricks.
     */
    private void addBricks() 
    {
        int y_offset = 15;
        int x_offset = 25;
        for(int i = 0; i < 10; i++) {
            for(int j = 0; j < 6; j++) {
                addObject(new Brick(), i*50+x_offset, j*25+y_offset);
            }
        }
    }
}