import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class EnemyCave here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class EnemyCave  extends AnimalHome
{
   /** Number of enemies that have come out so far. */
    private int enemies = 0;
    
    /** Total number of enemies in this hill. */
    private int maxEnemies = 40;

    /** Counter to show how much food have been collected so far. */
    private Counter foodCounter;
    
    /**
     * Constructor for enemy cave with default number of enemies (40).
     */
    public EnemyCave()
    {
    }

    /**
     * Construct an enemy cave with a given number of enemies.
     */
    public EnemyCave(int numberOfEnemies)
    {
        maxEnemies = numberOfEnemies;
    }

    /**
     * Act: If there are still enemies left inside, see whether one should come out.
     */
    public void act()
    {
        if(enemies < maxEnemies) 
        {
            if(Greenfoot.getRandomNumber(100) < 10) 
            {
                getWorld().addObject(new Enemy(this), getX(), getY());
                enemies++;
            }
        }
    }

    /**
     * Record that we have collected another bit of food.
     */
    public void countFood()
    {
        if(foodCounter == null) 
        {
            foodCounter = new Counter("Food: ");
            int x = getX();
            int y = getY() + getImage().getWidth()/2 + 8;

            getWorld().addObject(foodCounter, x, y);
        }        
        foodCounter.increment();
    }
}
