import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

/**
 * An ant that collects food.
 * 
 * @author Michael Kolling
 * @version 0.1
 */
public class Ant extends Creature
{
    private boolean carryingFood = false;
    
    /**
     * Create an ant with a given home hill. The initial speed is zero (not moving).
     */
    public Ant(AntHill home)
    {
        setHomeHill(home);
    }

    /**
     * Do what an ant's gotta do.
     */
    public void act()
    {
        /**
         * if(carrying food) 
         *    walk towards home
         *    when they arrive home, drop off the food
         * else
         *    wander about until you find food
         */
        
         if(carryingFood) {
             walkTowardsHome();
             checkIfHome();
         }
         else {
             randomWalk();
             checkForFood();
         }
    }
    
    private void checkIfHome() {
        AntHill hill = (AntHill)getOneIntersectingObject(AntHill.class);
        if(hill != null) {
           setImage("ant.gif");
           carryingFood = false;
           hill.countFood();
        }
    }
    
    private void checkForFood() {
        if(getOneIntersectingObject(Food.class) != null) {
           setImage("ant-with-food.gif");
           carryingFood = true;
        }
    }

}