import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

/**
 * An ant that collects food.
 * 
 * @author Michael Kolling
 * @version 0.1
 */
public class Ant extends Creature
{
    private boolean carryingFood = false;
    private int foundPheromone = 0;
    private int pheromoneIntensity = 0;
    
    /**
     * Create an ant with a given home hill. The initial speed is zero (not moving).
     */
    public Ant(AntHill home)
    {
        setHomeHill(home);
    }

    /**
     * Do what an ant's gotta do.
     */
    public void act()
    {
        /**
         * if(carrying food) 
         *    walk towards home
         *    when they arrive home, drop off the food
         * else
         * if(we recently found a drop of pheromone)
         *    walk away from home
         * else if (we find a pheromone now) 
         *    walk towards the center of the pheromone drop
         *    if(we are at the pheromone drop center)
         *       note that we found pheromone
         * walk about randomly
         * check for food
         */
         if(carryingFood) {
             walkTowardsHome();
             dropPheromone();
             checkIfHome();
         }
         else {
             if(foundPheromone > 0) { //we recently found a pheromone
                 foundPheromone = foundPheromone - 1;
                 walkAwayFromHome();
             }
             else if(getOneIntersectingObject(Pheromone.class) != null) {
                 //walk towards the center of the pheromone drop
                 walkTowardsPheromone();
             }
             randomWalk();
             checkForFood();
         }
    }
    
    private void checkIfHome() {
        AntHill hill = (AntHill)getOneIntersectingObject(AntHill.class);
        if(hill != null) {
           setImage("ant.gif");
           carryingFood = false;
           hill.countFood();
        }
    }
    
    private void checkForFood() {
        Food food = (Food)getOneIntersectingObject(Food.class);
        if(food != null) {
           setImage("ant-with-food.gif");
           carryingFood = true;
           food.takeSomeFood();
        }
    }
    
    private void dropPheromone() {
        if(pheromoneIntensity == 36) {
            getWorld().addObject(new Pheromone(), getX(), getY());
            pheromoneIntensity = 0;
        }
        else {
            pheromoneIntensity = pheromoneIntensity + 1;
        }
    }
    
    private void walkTowardsPheromone() {
        Pheromone pheromone = (Pheromone)getOneIntersectingObject(Pheromone.class);
        if(pheromone != null) {
            headTowards(pheromone);
            walk();
            if(pheromone.getX() == getX() && pheromone.getY() == getY()) {
                foundPheromone = 15;
            }
        }
    }

}