import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Ambulance here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Ambulance  extends Actor
{
    private static final double WALKING_SPEED = 20;
    
    /**
     * Act - do whatever the Ambulance wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
        move();
        checkEdges();
        checkForBarrels();
    } 
    
    public void move() 
    {
        double angle = Math.toRadians( getRotation() );
        int x = (int) Math.round(getX() + Math.cos(angle) * WALKING_SPEED);
        int y = (int) Math.round(getY() + Math.sin(angle) * WALKING_SPEED);
        
        setLocation(x, y);  
    }
    
    public void checkEdges()
    {
        if(getX() == 0)
        {
            //setRotation(getRotation() + 39);
            setLocation(getWorld().getWidth(), getY());
        }
        if(getX() >= getWorld().getWidth() - 1)
        {
            setRotation(getRotation() + 39);
        }
        if(getY()==0)
        {
            setRotation(getRotation() + 39);
        }
        if(getY() >= getWorld().getHeight() - 1)
        {
            setRotation(getRotation() + 39);
        }
    }
    
    public void checkForBarrels()
    {
        Actor actor = getOneIntersectingObject(Barrel.class);
        if(actor != null)
        {
            actor.setImage(new GreenfootImage("flower2.png"));
        }
    }
}
