import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Ambulance here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Ambulance  extends Actor
{
    private static final double WALKING_SPEED = 20;
    
    /**
     * Act - do whatever the Ambulance wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
        move();
        checkEdges();
        checkForBarrels();
        checkForCars();
    } 
    
    public void move() 
    {
        double angle = Math.toRadians( getRotation() );
        int x = (int) Math.round(getX() + Math.cos(angle) * WALKING_SPEED);
        int y = (int) Math.round(getY() + Math.sin(angle) * WALKING_SPEED);
        
        setLocation(x, y);  
    }
    
    public void checkEdges()
    {
        if(getX() == 0)
        {
            //setRotation(getRotation() + 39);
            setLocation(getWorld().getWidth(), getY());
        }
        else if(getX() >= getWorld().getWidth() - 1)
        {
            setRotation(getRotation() + 39);
        }
        
        
        if(getY()==0)
        {
            setRotation(getRotation() + 39);
        }
        else if(getY() >= getWorld().getHeight() - 1)
        {
            setRotation(getRotation() + 39);
        }
    }
    
    public void checkForBarrels()
    {
        Actor actor = getOneIntersectingObject(Barrel.class);
        if(actor != null)
        {
            //actor.setImage(new GreenfootImage("flower2.png"));
            //setRotation(getRotation() + 39);
        }
    }
    
    /*
     * When the ambulance hits a car, if the car has hit more than 5 barrels, then
     * remove that car from the scenario.  Otherwise, turn that car into a flower.
     */
    public void checkForCars() 
    {
        Car car = (Car)getOneIntersectingObject(Car.class);
        if(car != null)
        {
           if(car.getBarrelsHit() > 5)
           {
               getWorld().removeObject(car);
           }
           else 
           {
                car.setImage(new GreenfootImage("flower2.png"));
           }
        }
    }
}
