import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Ambulance here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Ambulance  extends Actor
{
    private static final double WALKING_SPEED = 20;
    
    /**
     * Act - do whatever the Ambulance wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
        move();
        checkEdges();
        checkForBarrels();
        checkForCars();
        checkHorizontalPosition();
        checkVerticalPosition();
    } 
    
    public void move() 
    {
        double angle = Math.toRadians( getRotation() );
        int x = (int) Math.round(getX() + Math.cos(angle) * WALKING_SPEED);
        int y = (int) Math.round(getY() + Math.sin(angle) * WALKING_SPEED);
        
        setLocation(x, y);  
    }
    
    public void checkEdges()
    {
        if(getX() == 0)
        {
            //setRotation(getRotation() + 39);
            setLocation(getWorld().getWidth(), getY());
        }
        else if(getX() >= getWorld().getWidth() - 1)
        {
            setRotation(getRotation() + 39);
        }
        
        
        if(getY()==0)
        {
            setRotation(getRotation() + 39);
        }
        else if(getY() >= getWorld().getHeight() - 1)
        {
            setRotation(getRotation() + 39);
        }
    }
    
    public void checkForBarrels()
    {
        Actor actor = getOneIntersectingObject(Barrel.class);
        if(actor != null)
        {
            //actor.setImage(new GreenfootImage("flower2.png"));
            //setRotation(getRotation() + 39);
        }
    }
    
    /*
     * When the ambulance hits a car, if the car has hit more than 5 barrels, then
     * remove that car from the scenario.  Otherwise, turn that car into a flower.
     */
    public void checkForCars() 
    {
        Car car = (Car)getOneIntersectingObject(Car.class);
        if(car != null)
        {
           if(car.getBarrelsHit() > 5)
           {
               getWorld().removeObject(car);
           }
           else 
           {
                car.setImage(new GreenfootImage("flower2.png"));
           }
        }
    }
    
    /*
     * When the ambulance is at point 137 in the left-right position, remove all
     * the barrels from the world.
     */
    public void checkHorizontalPosition()
    {
        if(/* ambulance is at x = 137 */ getX() >= 130 && getX() <= 140)
        { 
            //remove all barrels from world
            getWorld().removeObjects(getWorld().getObjects(Barrel.class));
        }
    }
    
    /*
     * When the ambulance is at point 36 in the up-down direction, add 5 flowers to
     * the world.
     */
    public void checkVerticalPosition()
    {
        //if-then structure
        if(/*figure out when the ambulance is at y=36*/ getY() >= 36 && getY() <= 50)
        {
           //add the flowers to the world
           //getWorld().addObject(new Flower(), Greenfoot.getRandomNumber(getWorld().getWidth()), Greenfoot.getRandomNumber(getWorld().getHeight()));
           //getWorld().addObject(new Flower(), Greenfoot.getRandomNumber(getWorld().getWidth()), Greenfoot.getRandomNumber(getWorld().getHeight()));
           //getWorld().addObject(new Flower(), Greenfoot.getRandomNumber(getWorld().getWidth()), Greenfoot.getRandomNumber(getWorld().getHeight()));
           //getWorld().addObject(new Flower(), Greenfoot.getRandomNumber(getWorld().getWidth()), Greenfoot.getRandomNumber(getWorld().getHeight()));
           //getWorld().addObject(new Flower(), Greenfoot.getRandomNumber(getWorld().getWidth()), Greenfoot.getRandomNumber(getWorld().getHeight()));
           
           //for-loop that creates 5 or 50 or 500 flowers (change condition to get more flowers)
           //inside the parentheses: initialization step
           //                        condition
           //                        increment step
           for(int count = 0; count < 500; count++)
           { //this is the code that gets repeated
             getWorld().addObject(new Flower(), Greenfoot.getRandomNumber(getWorld().getWidth()), Greenfoot.getRandomNumber(getWorld().getHeight()));
           }
        }
    }
}
