import greenfoot.World;
import greenfoot.Actor;
import greenfoot.*;

public class LiftController extends Actor
{
    /**
     *  The building this lift controller belongs in
     */
    private Building _building;
    private java.util.Queue<ElevatorCall> _queue;
    
    public LiftController(Building building)
    {
        _building = building;
        _queue = new java.util.LinkedList<ElevatorCall>();
    }

    public void act()
    {
        //get the first call from the queue and send the elevator there
        if(!_queue.isEmpty()) {
            ElevatorCall call = _queue.remove();
            _building.sendElevator(call.getDestinationFloor());
        }
    }
    
    public void elevatorCallReceived(ElevatorCall call) {
        if(!_queue.contains(call)) {
            _queue.add(call);
        }
    }

}