import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.awt.Color;

/**
 * A 'Body' is any kind of object in space that has a mass. It could be a star, or a planet, 
 * or anything else that floats around in space.
 * 
 * @author Michael Kolling 
 * @version 0.1
 */
public class Body extends SmoothMover
{
    // constants
    private static final double GRAVITY = 5.8;
    private static final Color defaultColor = new Color(255, 216, 0);
    
    // fields
    private double mass;
    
    /**
     * Construct a Body with default size, mass, movement and color.
     */
    public Body()
    {
        this (20, 300, new Vector(0, 1.0), defaultColor);
    }
    
    /**
     * Construct a Body with a specified size, mass, movement and color.
     */
    public Body(int size, double mass, Vector movement, Color color)
    {
        this.mass = mass;
        addForce(movement);
        GreenfootImage image = new GreenfootImage (size, size);
        image.setColor (color);
        image.fillOval (0, 0, size-1, size-1);
        setImage (image);
    }
    
    /**
     * Act. That is: apply  the gravitation forces from
     * all other bodies around, and then move.
     */
    public void act() 
    {
        //Apply gravity to body
        applyForces();
        
        //Move the body
        move();
    }
    
    
    private void applyForces() 
    {
        //get all the other planets in space and store them in a variable
        java.util.List<Body> bodies = getWorld().getObjects(Body.class);
        
        //for each of those planets
        //for (TypeOfElementInCollection name: collectionName)
        for(Body b: bodies)
        //"for each Body named b in the list bodies, do:"
        {
            //"apply the gravity from that planet to ourselves, making sure not to
            // apply our own self to ourselves"
            if(b != this)
            {
                applyGravity(b);
            }
        }
    }
    
    private void applyGravity (Body otherBody) 
    {
        double dx = otherBody.getExactX() - this.getExactX();
        double dy = otherBody.getExactY() - this.getExactY();
        Vector force = new Vector(dx, dy);
        double distance = Math.sqrt(dx * dx + dy * dy);
        double strength = GRAVITY * this.mass * otherBody.mass/(distance * distance);
        double acceleration = strength/this.mass;
        force.setLength(acceleration);
        addForce(force);
    }
    
    /**
     * Return the mass of this body.
     */
    public double getMass()
    {
        return mass;
    }
}
