import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

/**
 * An ant that collects food.
 * 
 * @author Michael Kolling
 * @version 0.1
 */
public class Ant extends Creature
{
    private boolean carryingFood = false;
    
    /**
     * Create an ant with a given home hill. The initial speed is zero (not moving).
     */
    public Ant(AntHill home)
    {
        setHomeHill(home);
    }

    /**
     * Do what an ant's gotta do.
     */
    public void act()
    {
        /**
         * if(carrying food) 
         *   head towards home
         *   check if we've made it home
         * else
         *   wander about until you find food
         */
        
        if(carryingFood) {
            walkTowardsHome();
            checkIfHome();
        }
        else {
            randomWalk();
            checkForFood();
        }
    }
    
    private void checkIfHome() {
        AntHill hill = (AntHill)getOneIntersectingObject(AntHill.class);
        if(hill != null) {
            carryingFood = false;
            hill.countFood();
            setImage("ant.gif");
        }
    }
    
    private void checkForFood() {
        if(getOneIntersectingObject(Food.class)!= null) {
            carryingFood = true;
            setImage("ant-with-food.gif");
        }
    }

}