import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

/**
 * An ant that collects food.
 * 
 * @author Michael Kolling
 * @version 0.1
 */
public class Ant extends Creature
{
    private boolean carryingFood = false;
    private int pheromoneIntensity = 0;
    private boolean smellPheromone = false;
    
    /**
     * Create an ant with a given home hill. The initial speed is zero (not moving).
     */
    public Ant(AntHill home)
    {
        setHomeHill(home);
    }

    /**
     * Do what an ant's gotta do.
     */
    public void act()
    {
        /**
         * if(carrying food) 
         *   head towards home
         *   drop a pheromone if its time
         *   check if we've made it home
         * else
         *   if(we have smelled a pheromone recently)
         *      walk away from home
         *   else if(we smell a pheromone now)
         *      note that we smell the pheromone
         *   else
         *      wander about until you find food
         */
        
        if(carryingFood) {
            walkTowardsHome();
            dropPheromone();
            checkIfHome();
        }
        else {
            if(smellPheromone) {
                walkAwayFromHome();
            }
            else if(getOneIntersectingObject(Pheromone.class) != null) {
                smellPheromone = true;
            }
            else {
                randomWalk();
                checkForFood();
            }
        }
    }
    
    private void checkIfHome() {
        AntHill hill = (AntHill)getOneIntersectingObject(AntHill.class);
        if(hill != null) {
            carryingFood = false;
            hill.countFood();
            setImage("ant.gif");
        }
    }
    
    private void checkForFood() {
        Food food = (Food)getOneIntersectingObject(Food.class);
        if(food != null) {
            carryingFood = true;
            setImage("ant-with-food.gif");
            food.takeFood();
        }
    }
    
    private void dropPheromone() {
        pheromoneIntensity = pheromoneIntensity + 1;
        
        if(pheromoneIntensity == 18) {
            getWorld().addObject(new Pheromone(), getX(), getY());
            pheromoneIntensity = 0;
        }
    }

}