import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Ambulance here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Ambulance  extends Actor
{
    private static final double WALKING_SPEED = 20;
    
    /**
     * Act - do whatever the Ambulance wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
        move();
        checkForEdges();
        checkForBarrels();
    }    
    
    public void move()
    {
        double angle = Math.toRadians( getRotation() );
        int x = (int) Math.round(getX() + Math.cos(angle) * WALKING_SPEED);
        int y = (int) Math.round(getY() + Math.sin(angle) * WALKING_SPEED);
        
        setLocation(x, y);
        //setLocation(getX() + 3, getY() + 4);
    }

    
    public void checkForEdges()
    {
        if(getX() == 0)
        {
            //setRotation(getRotation() + 24);
            setLocation(getWorld().getWidth(), getY());
        }
        if(getX() >= getWorld().getWidth() - 1)
        {
            //setRotation(getRotation() + 24);
            setLocation(0, getY());
        }
        if(getY() == 0)
        {
            setRotation(getRotation() + 24);
        }
        if(getY() >= getWorld().getHeight() - 1)
        {
            setRotation(getRotation() + 24);
        }
    }
    
    public void checkForBarrels() 
    {
        Actor actor = getOneIntersectingObject(Barrel.class);
        if(actor != null)
        {
            //setRotation(getRotation() + 24);
            actor.setImage(new GreenfootImage("flower2.png"));
        }
    }
}

