import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Ambulance here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class Ambulance  extends Actor
{
    private static final double WALKING_SPEED = 20;
    
    /**
     * Act - do whatever the Ambulance wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
        move();
        checkForEdges();
        checkForBarrels();
        checkForCars();
        checkForHorizontalPosition();
    }    
    
    public void move()
    {
        double angle = Math.toRadians( getRotation() );
        int x = (int) Math.round(getX() + Math.cos(angle) * WALKING_SPEED);
        int y = (int) Math.round(getY() + Math.sin(angle) * WALKING_SPEED);
        
        setLocation(x, y);
        //setLocation(getX() + 3, getY() + 4);
    }

    
    public void checkForEdges()
    {
        if(getX() == 0)
        {
            //setRotation(getRotation() + 24);
            setLocation(getWorld().getWidth(), getY());
        }
        else if(getX() >= getWorld().getWidth() - 1)
        {
            //setRotation(getRotation() + 24);
            setLocation(0, getY());
        }
        if(getY() == 0)
        {
            setRotation(getRotation() + 24);
        }
        else if(getY() >= getWorld().getHeight() - 1)
        {
            setRotation(getRotation() + 24);
        }
    }
    
    public void checkForBarrels() 
    {
        Actor actor = getOneIntersectingObject(Barrel.class);
        if(actor != null)
        {
            //setRotation(getRotation() + 24);
            //actor.setImage(new GreenfootImage("flower2.png"));
        }
    }
    
    /* 
     * When an ambulance hits a car, if the car has hit more than 5 barrels, the car
     * will be removed from the scenario.  Otherwise, the car will turn into a flower.
     */
    public void checkForCars()
    {
        Car car = (Car)getOneIntersectingObject(Car.class);
        if(car != null)
        {
            if(car.getBarrelsHit() > 5)
            {
                //remove the car from the scenario
                getWorld().removeObject(car);
            }
            else
            {
                //turn the car into a flower
                car.setImage(new GreenfootImage("flower2.png"));
            }
            
        }
    }
    
    /*
     * When ambulance is at the point 137 in left-right direction, remove all 
     * barrels from the world
     */
    public void checkForHorizontalPosition()
    {
        //if(getX is equal to 137)
        if(getX() >= 137)
        {
            //remove all objects that are barrels
            getWorld().removeObjects(getWorld().getObjects(Barrel.class));
        }
    }
}

