/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JPrimitiveType;

public abstract class JType
implements JGenerable {
    public static JPrimitiveType parse(JCodeModel codeModel, String typeName) {
        if (typeName.equals("void")) {
            return codeModel.VOID;
        }
        if (typeName.equals("boolean")) {
            return codeModel.BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return codeModel.BYTE;
        }
        if (typeName.equals("short")) {
            return codeModel.SHORT;
        }
        if (typeName.equals("char")) {
            return codeModel.CHAR;
        }
        if (typeName.equals("int")) {
            return codeModel.INT;
        }
        if (typeName.equals("float")) {
            return codeModel.FLOAT;
        }
        if (typeName.equals("long")) {
            return codeModel.LONG;
        }
        if (typeName.equals("double")) {
            return codeModel.DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + typeName);
    }

    public abstract JCodeModel owner();

    public abstract String fullName();

    public abstract String name();

    public abstract JClass array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public JType elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.fullName() + ")";
    }

    public abstract void generate(JFormatter var1);
}

