/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.postgresql.util.MessageTranslator;

public class PSQLException
extends SQLException {
    private String message;

    public PSQLException(String error) {
        this.translate(error, null);
    }

    public PSQLException(String error, Object[] args) {
        this.translate(error, args);
    }

    public PSQLException(String error, Object arg) {
        Object[] argv = new Object[]{arg};
        this.translate(error, argv);
    }

    public PSQLException(String error, Exception ex) {
        Object[] argv = new Object[1];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.println("Exception: " + ex.toString() + "\nStack Trace:\n");
            ex.printStackTrace(pw);
            pw.println("End of Stack Trace");
            pw.flush();
            argv[0] = baos.toString();
            pw.close();
            baos.close();
        }
        catch (Exception ioe) {
            argv[0] = ex.toString() + "\nIO Error on stack trace generation! " + ioe.toString();
        }
        this.translate(error, argv);
    }

    public PSQLException(String error, Object arg1, Object arg2) {
        Object[] argv = new Object[]{arg1, arg2};
        this.translate(error, argv);
    }

    private void translate(String error, Object[] args) {
        this.message = MessageTranslator.translate(error, args);
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.message;
    }
}

