/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo;

import edu.buffalo.nsf.hippo.Configurable;
import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.InternalProblem;
import edu.buffalo.nsf.hippo.data.CachedDataSource;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.DataSourceCache;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTranslator;
import edu.buffalo.nsf.hippo.prolog.ProverFactory;
import edu.buffalo.nsf.hippo.util.ConfigurableContainer;
import edu.buffalo.nsf.hippo.util.DataSourceContainer;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EnvironmentImpl
implements Environment {
    protected static Logger logger;
    protected DataSourceContainer sources = new DataSourceContainer(100);
    protected ConfigurableContainer cs = new ConfigurableContainer(100);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.EnvironmentImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void shutdown() {
        logger.info((Object)"Shutting down the enviroment.");
        Iterator ic = this.cs.iterator();
        while (ic.hasNext()) {
            ((Configurable)ic.next()).shutdown();
        }
        Iterator ds = this.sources.iterator();
        while (ds.hasNext()) {
            ((Configurable)ds.next()).shutdown();
        }
        this.sources = null;
        logger.info((Object)"Environment shutdown complete.");
    }

    public Connection getConnection(Configuration config) {
        try {
            Class.forName(config.getDBDriverName());
            String connectURI = config.getDBConnectURI();
            String user = config.getDBUser();
            String password = config.getDBPassword();
            return DriverManager.getConnection(connectURI, user, password);
        }
        catch (Throwable t) {
            throw new InternalProblem("Exception caught while creating a new database connection.", t);
        }
    }

    protected DataSource createDataSource(Configuration config) {
        logger.info((Object)"creating datasource!");
        Configurable s = this.getConfigurable(config.getDataSourceName(), config);
        return (DataSource)s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(Configuration config) {
        DataSourceContainer dataSourceContainer = this.sources;
        synchronized (dataSourceContainer) {
            if (!this.sources.contains(config)) {
                this.sources.put(config, this.createDataSource(config));
            }
        }
        DataSource s = this.sources.get(config);
        if (config.isDataSourceCached()) {
            int cacheSize = config.getDataSourceCacheSize();
            DataSourceCache cache = new DataSourceCache(cacheSize);
            s = new CachedDataSource(s, cache);
        }
        logger.info((Object)("dispatching data source " + s));
        return s;
    }

    protected void createConfigurable(String name, Configuration config) {
        try {
            Class<?> c = Class.forName(name);
            Class[] paramTypes = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("edu.buffalo.nsf.hippo.Environment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            paramTypes[0] = clazz;
            Constructor<?> constr = c.getConstructor(paramTypes);
            Object[] params = new Object[]{this};
            Configurable o = (Configurable)constr.newInstance(params);
            this.cs.put(name, config, o);
            o.init(config);
        }
        catch (Exception exc) {
            logger.error((Object)("Exception caught while creating Configurable instance (" + name + ")"), (Throwable)exc);
            throw new InternalProblem(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configurable getConfigurable(String name, Configuration config) {
        ConfigurableContainer configurableContainer = this.cs;
        synchronized (configurableContainer) {
            if (!this.cs.contains(name, config)) {
                this.createConfigurable(name, config);
            }
        }
        return this.cs.get(name, config);
    }

    public ProverFactory getProverFactory(String name, Configuration config) {
        return (ProverFactory)this.getConfigurable(name, config);
    }

    public ProverFactory getProverFactory(Configuration config) {
        return this.getProverFactory(config.getProverFactoryName(), config);
    }

    public Engine getEngine(Configuration config) {
        return (Engine)this.getConfigurable(config.getEngineName(), config);
    }

    public QueryTranslator getTranslator(Configuration config) {
        return (QueryTranslator)this.getConfigurable(config.getTranslatorName(), config);
    }

    public QueryTransformer getCoreOperator(Configuration config) {
        return (QueryTransformer)this.getConfigurable(config.getCoreOperatorName(), config);
    }

    public QueryTransformer getShellOperator(Configuration config) {
        return (QueryTransformer)this.getConfigurable(config.getShellOperatorName(), config);
    }

    public QueryTransformer getEnvelopeOperator(Configuration config) {
        return (QueryTransformer)this.getConfigurable(config.getEnvelopeOperatorName(), config);
    }

    public void dispose(Configurable c) {
        logger.info((Object)("disposing configurable object " + c));
        if (!(c instanceof DataSource)) {
            c.shutdown();
        }
    }

    public void release(Connection db) {
        try {
            db.close();
        }
        catch (SQLException exc) {
            logger.error((Object)"Exception caught.", (Throwable)exc);
        }
    }
}

