/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data;

import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Map;
import org.apache.commons.collections.LRUMap;
import org.apache.log4j.Logger;

public class DataSourceCache {
    protected static Logger logger;
    protected Map vertices;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.DataSourceCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public DataSourceCache() {
        this.vertices = Util.createMap();
    }

    public DataSourceCache(DataSourceCache cache1, DataSourceCache cache2) {
        this.vertices = Util.createMap();
        this.vertices.putAll(cache1.vertices);
        this.vertices.putAll(cache2.vertices);
    }

    public DataSourceCache(int capacity) {
        this.vertices = capacity == 0 ? Util.createMap() : new LRUMap(capacity);
    }

    public boolean check(Vertex v) {
        return this.vertices.containsKey(v);
    }

    public void store(Vertex v, boolean b) {
        this.vertices.put(v, new Boolean(b));
    }

    public Boolean search(Vertex v) {
        return (Boolean)this.vertices.get(v);
    }

    public boolean read(Vertex v) {
        try {
            return this.search(v);
        }
        catch (NullPointerException exc) {
            throw new IllegalArgumentException("Information on given vertex is not contained in this cache.");
        }
    }

    public int size() {
        return this.vertices.size();
    }

    public void clear() {
        this.vertices.clear();
    }

    public String toString() {
        return "Cache: " + this.vertices;
    }
}

