/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.graph;

import edu.buffalo.nsf.hippo.data.config.Bind;
import edu.buffalo.nsf.hippo.data.config.DenialConstraint;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.util.HashUtil;
import edu.buffalo.nsf.hippo.util.Util;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Edge {
    private static Logger logger;
    protected Set vertices;
    protected int hashCode;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.graph.Edge");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    protected Edge(Collection vertices) {
        this.vertices = Util.toSet(vertices);
        this.hashCode = HashUtil.hashCode(this);
    }

    public static Edge create(DenialConstraint dc, Map schema, Tuple t) {
        Set vertices = Util.createSet();
        int index = 0;
        int i = 0;
        while (i < dc.getBindingLength()) {
            Bind b = dc.getBinding(i);
            String name = b.getRelationName();
            Relation r = (Relation)schema.get(name);
            int count = r.getFieldLength();
            Tuple sub = Tuple.extract(t, index, count);
            Vertex v = Vertex.create(name, sub);
            vertices.add(v);
            index += count;
            ++i;
        }
        return new Edge(vertices);
    }

    public Set getNeighbors(Vertex v) {
        Set neighbors = Util.createSet(this.vertices);
        neighbors.remove(v);
        return neighbors;
    }

    public Set getVertices() {
        return this.vertices;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static boolean equal(Edge e1, Edge e2) {
        boolean result = e1 == e2 || e1.getVertices().equals(e2.getVertices());
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Edge) {
            return Edge.equal(this, (Edge)o);
        }
        return false;
    }

    public String toString() {
        return "E:" + this.vertices;
    }
}

