/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.Configurable;
import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSourceCache;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.formula.Value;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.WhereCompValue;
import edu.buffalo.nsf.hippo.data.query.WhereComparator;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryWalker;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import java.util.Map;
import org.apache.log4j.Logger;

public class KnowledgeHarvester
extends QueryWalker
implements Configurable {
    protected Logger logger;
    protected Environment env;
    protected Map schema;
    protected String coreSuffix;
    protected int varIndex;
    protected DataSourceCache cache;
    protected Tuple t;
    static /* synthetic */ Class class$0;

    public KnowledgeHarvester(Environment env) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.query.traverse.KnowledgeHarvester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger((Class)clazz);
        this.env = env;
    }

    public void init(Configuration config) {
        this.schema = config.getSchema();
        this.coreSuffix = config.getCoreSuffix();
    }

    public void shutdown() {
    }

    protected Relation getRelation(String relName) {
        if (relName.endsWith(this.coreSuffix)) {
            relName = relName.substring(0, relName.length() - this.coreSuffix.length());
        }
        return (Relation)this.schema.get(relName);
    }

    public DataSourceCache gather(Query q, Tuple t) {
        this.varIndex = 0;
        this.t = t;
        this.cache = new DataSourceCache();
        this.traverse(q);
        return this.cache;
    }

    protected void traverseOuterJoin(Query q, int length, Relation[] rel, int[] offset) {
        this.traverse(q);
        int off = length;
        int i = 0;
        while (i < rel.length) {
            Vertex v;
            Tuple t1 = Tuple.extract(this.t, off, rel[i].getFieldLength());
            if (!t1.isNULL()) {
                v = Vertex.create(rel[i].getName(), t1);
                if (this.cache != null) {
                    this.cache.store(v, true);
                }
            } else {
                v = Vertex.create(rel[i].getName(), Tuple.extract(this.t, offset[i], rel[i].getFieldLength()));
                if (this.cache != null) {
                    this.cache.store(v, false);
                }
            }
            off += rel[i].getFieldLength();
            ++i;
        }
    }

    protected void traverseSelect(SelectList selectList, FromList fromList, WhereCondition whereCondition, GroupByList groupByList) {
        this.traverseFromList(fromList.getFromExpr());
    }

    protected void traverseSelectList(SelectExpr[] selectExpr) {
    }

    protected void traverseSelectConstant(Object c) {
    }

    protected void traverseSelectField(String bindName, String fieldName) {
    }

    protected void traverseFromList(FromExpr[] fromExpr) {
        int i = 0;
        while (i < fromExpr.length) {
            this.traverse(fromExpr[i]);
            ++i;
        }
    }

    protected void traverseFromRelation(String relName, String bindName) {
        Relation r = this.getRelation(relName);
        Vertex v = Vertex.create(relName, Tuple.extract(this.t, this.varIndex, r.getFieldLength()));
        if (this.cache != null) {
            this.cache.store(v, true);
        }
        this.varIndex += r.getFieldLength();
    }

    protected void traverseFromSubquery(Query q, String bindName) {
        this.traverse(q);
    }

    protected void traverseWhereComparison(WhereCompValue val1, WhereComparator comp, WhereCompValue val2) {
    }

    protected void traverseWhereConjunction(WhereCondition cond1, WhereCondition cond2) {
    }

    protected void traverseWhereDisjunction(WhereCondition cond1, WhereCondition cond2) {
    }

    protected void traverseWhereNegation(WhereCondition cond) {
    }

    protected Value traverseWhereSelectValue(String bindName, String fieldName) {
        return null;
    }

    protected Value traverseWhereConstant(Object c) {
        return null;
    }

    protected void traverseDifference(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        this.traverse(expr1);
    }

    protected void traverseIntersection(Query expr1, Query expr2) {
        int _varIndex = this.varIndex;
        this.traverse(expr1);
        this.varIndex = _varIndex;
        this.traverse(expr2);
    }

    protected void traverseUnion(Query expr1, Query expr2) {
        DataSourceCache _cache = this.cache;
        this.cache = null;
        this.traverse(expr1);
        this.cache = _cache;
    }
}

