/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.FromSubquery;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Intersection;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.Select;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.Union;
import edu.buffalo.nsf.hippo.data.query.WhereCompValue;
import edu.buffalo.nsf.hippo.data.query.WhereComparator;
import edu.buffalo.nsf.hippo.data.query.WhereComparison;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.data.query.WhereConjunction;
import edu.buffalo.nsf.hippo.data.query.WhereConstant;
import edu.buffalo.nsf.hippo.data.query.WhereDisjunction;
import edu.buffalo.nsf.hippo.data.query.WhereNegation;
import edu.buffalo.nsf.hippo.data.query.WhereSelectValue;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;

public abstract class PhonyTransformer
implements QueryTransformer {
    public Query transform(Query q) {
        if (q instanceof Select) {
            Select s = (Select)q;
            return this.transformSelect(s.getSelectList(), s.getFromList(), s.getWhereCondition(), s.getGroupByList());
        }
        if (q instanceof Difference) {
            Difference d = (Difference)q;
            return this.transformDifference(d.getExpr1(), d.getExpr2());
        }
        if (q instanceof Intersection) {
            Intersection i = (Intersection)q;
            return this.transformIntersection(i.getExpr1(), i.getExpr1());
        }
        if (q instanceof Union) {
            Union u = (Union)q;
            return this.transformUnion(u.getExpr1(), u.getExpr2());
        }
        throw new IllegalArgumentException("Unknown Query subclass.");
    }

    protected FromExpr transform(FromExpr fromExpr) {
        if (fromExpr instanceof FromRelation) {
            FromRelation r = (FromRelation)fromExpr;
            return this.transformFromRelation(r.getRelationName(), r.getBindingName());
        }
        if (fromExpr instanceof FromSubquery) {
            FromSubquery s = (FromSubquery)fromExpr;
            return this.transformFromSubquery(s.getSubquery(), s.getBindingName());
        }
        throw new IllegalArgumentException("Unknown FromExpr subclass.");
    }

    protected WhereCondition transform(WhereCondition whereCondition) {
        if (whereCondition == null) {
            return null;
        }
        if (whereCondition instanceof WhereComparison) {
            WhereComparison cmp = (WhereComparison)whereCondition;
            return this.transformWhereComparison(cmp.getComparedValue1(), cmp.getComparator(), cmp.getComparedValue2());
        }
        if (whereCondition instanceof WhereConjunction) {
            WhereConjunction c = (WhereConjunction)whereCondition;
            return this.transformWhereConjunction(c.getCondition1(), c.getCondition2());
        }
        if (whereCondition instanceof WhereDisjunction) {
            WhereDisjunction d = (WhereDisjunction)whereCondition;
            return this.transformWhereDisjunction(d.getCondition1(), d.getCondition2());
        }
        if (whereCondition instanceof WhereNegation) {
            WhereNegation n = (WhereNegation)whereCondition;
            return this.transformWhereNegation(n.getCondition());
        }
        throw new IllegalArgumentException("Unknown WhereCondition subclass.");
    }

    protected WhereCompValue transform(WhereCompValue val) {
        if (val instanceof WhereSelectValue) {
            WhereSelectValue s = (WhereSelectValue)val;
            return this.transformWhereSelectValue(s.getBindingName(), s.getFieldName());
        }
        if (val instanceof WhereConstant) {
            WhereConstant c = (WhereConstant)val;
            return this.transformWhereConstant(c.getConstant());
        }
        throw new IllegalArgumentException("Unknown WhereCompValue subclass.");
    }

    protected Query transformSelect(SelectList selectList, FromList fromList, WhereCondition whereCondition, GroupByList groupByList) {
        if (groupByList != null) {
            throw new IllegalArgumentException("This translator can be used only for SJUID queires.");
        }
        return new Select(selectList, this.transformFromList(fromList.getFromExpr()), this.transform(whereCondition), groupByList);
    }

    protected FromList transformFromList(FromExpr[] fromExpr) {
        FromExpr[] f = new FromExpr[fromExpr.length];
        int i = 0;
        while (i < fromExpr.length) {
            f[i] = this.transform(fromExpr[i]);
            ++i;
        }
        return new FromList(f);
    }

    protected FromExpr transformFromRelation(String relName, String bindName) {
        return new FromRelation(relName, bindName);
    }

    protected FromSubquery transformFromSubquery(Query q, String bindName) {
        return new FromSubquery(this.transform(q), bindName);
    }

    protected WhereCondition transformWhereConjunction(WhereCondition cond1, WhereCondition cond2) {
        return new WhereConjunction(this.transform(cond1), this.transform(cond2));
    }

    protected WhereCondition transformWhereDisjunction(WhereCondition cond1, WhereCondition cond2) {
        return new WhereDisjunction(this.transform(cond1), this.transform(cond2));
    }

    protected WhereCondition transformWhereNegation(WhereCondition cond) {
        return new WhereNegation(this.transform(cond));
    }

    protected WhereCondition transformWhereComparison(WhereCompValue val1, WhereComparator comp, WhereCompValue val2) {
        WhereCompValue v1 = this.transform(val1);
        WhereCompValue v2 = this.transform(val2);
        return new WhereComparison(v1, comp, v2);
    }

    protected WhereCompValue transformWhereSelectValue(String bindName, String fieldName) {
        return new WhereSelectValue(bindName, fieldName);
    }

    protected WhereCompValue transformWhereConstant(Object c) {
        return new WhereConstant(c);
    }

    protected Query transformDifference(Query expr1, Query expr2) {
        return new Difference(this.transform(expr1), this.transform(expr2));
    }

    protected Query transformIntersection(Query expr1, Query expr2) {
        return new Intersection(this.transform(expr1), this.transform(expr2));
    }

    protected Query transformUnion(Query expr1, Query expr2) {
        return new Union(this.transform(expr1), this.transform(expr2));
    }
}

