/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.tuple;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.util.StatsManager;
import edu.buffalo.nsf.hippo.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class ListTupleStream
extends TupleStream {
    protected TupleMetaData metaData;
    protected List rows;
    protected int currentRow;

    public ListTupleStream(List rows, TupleMetaData metaData) {
        this.rows = Util.toList(rows);
        this.metaData = metaData;
        this.currentRow = -1;
    }

    public ListTupleStream(ResultSet rs) throws SQLException {
        this(rs, TupleMetaData.create(rs.getMetaData()));
    }

    public ListTupleStream(ResultSet rs, TupleMetaData metaData) throws SQLException {
        int fieldCount = metaData.getFieldCount();
        this.metaData = metaData;
        this.rows = Util.createList();
        while (rs.next()) {
            Object[] row = new Object[fieldCount];
            int j = 0;
            while (j < fieldCount) {
                row[j] = rs.getObject(j + 1);
                if (rs.wasNull()) {
                    row[j] = null;
                }
                ++j;
            }
            this.rows.add(Tuple.create(row));
        }
        StatsManager.peekStats().touch("Records transmited from database", this.rows.size());
        this.currentRow = -1;
    }

    public TupleMetaData getMetaData() {
        return this.metaData;
    }

    public boolean hasNext() {
        return this.currentRow + 1 < this.rows.size();
    }

    public Tuple getNext() {
        if (this.currentRow >= this.rows.size()) {
            return null;
        }
        return (Tuple)this.rows.get(++this.currentRow);
    }

    public String toString() {
        return "TS(" + this.metaData + ")[#" + this.rows.size() + "]";
    }
}

