/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.tuple;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.data.tuple.TupleStreamError;
import edu.buffalo.nsf.hippo.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLTupleStream
extends TupleStream {
    protected static Logger logger;
    protected TupleMetaData metaData;
    protected boolean hasNext = true;
    protected Tuple next;
    protected ResultSet rs;
    protected Statement stmt;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.tuple.SQLTupleStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public SQLTupleStream(ResultSet rs, Statement stmt) throws SQLException {
        this(rs, stmt, TupleMetaData.create(rs.getMetaData()));
    }

    public SQLTupleStream(ResultSet rs, Statement stmt, TupleMetaData metaData) {
        this.metaData = metaData;
        this.rs = rs;
        this.stmt = stmt;
        this.next = this.next();
    }

    protected void close() {
        try {
            this.rs.close();
            this.stmt.close();
        }
        catch (Throwable t) {
            logger.error((Object)"Throwable caught while closing SQLTupleStream.", t);
        }
    }

    protected void finalize() {
        this.close();
    }

    protected Tuple readTuple(ResultSet rs, int fieldCount) {
        try {
            Object[] row = new Object[fieldCount];
            int i = 0;
            while (i < fieldCount) {
                row[i] = rs.getObject(i + 1);
                if (rs.wasNull()) {
                    row[i] = null;
                }
                ++i;
            }
            return Tuple.create(row);
        }
        catch (SQLException exc) {
            logger.error((Object)"Exception caught.", (Throwable)exc);
            throw new TupleStreamError("Exception caught.", exc);
        }
    }

    protected Tuple next() {
        try {
            if (this.hasNext) {
                if (this.rs.next()) {
                    return this.readTuple(this.rs, this.metaData.getFieldCount());
                }
                this.hasNext = false;
                this.close();
            }
            return null;
        }
        catch (SQLException exc) {
            logger.error((Object)"Exception caught.", (Throwable)exc);
            throw new TupleStreamError("Exception caught.", exc);
        }
    }

    public TupleMetaData getMetaData() {
        return this.metaData;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Tuple getNext() {
        Tuple result = this.next;
        this.next = this.next();
        return result;
    }

    public String toString() {
        return "SQL-TS(" + this.metaData + ")" + "[#" + Util.getTupleCount(this.rs) + "]";
    }
}

