/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.nsf.hippo.data.tuple;

import edu.buffalo.nsf.hippo.util.Util;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TupleMetaData {
    protected static Logger logger;
    public static final int INTEGER = 4;
    public static final int REAL = 7;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int NULL = 0;
    public static final int OTHER = 1111;
    public static TupleMetaData NULL_META_DATA;
    public static TupleMetaData EMPTY_META_DATA;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.buffalo.nsf.hippo.data.tuple.TupleMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        NULL_META_DATA = null;
        EMPTY_META_DATA = new ArrayTupleMetaData(0, new String[0], new String[0]);
    }

    public abstract int getFieldCount();

    public abstract String getFieldName(int var1);

    public abstract String getFieldTypeName(int var1);

    public abstract int getFieldIndex(String var1);

    public boolean equals(Object o) {
        if (o instanceof TupleMetaData) {
            return TupleMetaData.equal(this, (TupleMetaData)o);
        }
        return false;
    }

    public static boolean equal(TupleMetaData md1, TupleMetaData md2) {
        if (md1 == md2) {
            return true;
        }
        boolean result = md1.getFieldCount() == md2.getFieldCount();
        return result;
    }

    public static TupleMetaData create(Object o) {
        String[] fieldName = new String[]{"UNKNOWN"};
        String[] fieldTypeName = new String[]{o.getClass().getName()};
        return new ArrayTupleMetaData(1, fieldName, fieldTypeName);
    }

    public static TupleMetaData create(ResultSetMetaData metaData) throws SQLException {
        int fieldCount = metaData.getColumnCount();
        String[] fieldName = new String[fieldCount];
        String[] fieldTypeName = new String[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            fieldName[i] = metaData.getColumnName(i + 1);
            fieldTypeName[i] = metaData.getColumnTypeName(i + 1);
            ++i;
        }
        return TupleMetaData.create(fieldCount, fieldName, fieldTypeName);
    }

    public static TupleMetaData create(int fieldCount, String[] fieldName, String[] fieldTypeName) {
        return new ArrayTupleMetaData(fieldCount, fieldName, fieldTypeName);
    }

    public static TupleMetaData getSubset(TupleMetaData metaData, int startField, int length) {
        return new SubsetTupleMetaData(metaData, startField, length);
    }

    public static TupleMetaData getUnion(TupleMetaData metaData1, TupleMetaData metaData2) {
        return new UnionTupleMetaData(metaData1, metaData2);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("TMetaData:[");
        int i = 0;
        while (i < this.getFieldCount()) {
            result.append(this.getFieldName(i)).append(':');
            result.append(this.getFieldTypeName(i)).append(',');
            ++i;
        }
        result.setCharAt(result.length() - 1, ']');
        return result + "]";
    }

    protected static class ArrayTupleMetaData
    extends TupleMetaData {
        protected int fieldCount;
        protected String[] fieldName;
        protected Map fieldIndex;
        protected String[] fieldTypeName;

        public ArrayTupleMetaData(int fieldCount, String[] fieldName, String[] fieldTypeName) {
            if (fieldName == null || fieldTypeName == null || fieldName.length != fieldCount || fieldTypeName.length != fieldCount) {
                throw new IllegalArgumentException("Incompatible arrays lengths.");
            }
            this.fieldCount = fieldCount;
            this.fieldName = fieldName;
            this.fieldTypeName = fieldTypeName;
            this.fieldIndex = ArrayTupleMetaData.createFieldIndexMap(fieldName);
        }

        protected static Map createFieldIndexMap(String[] fieldName) {
            Map fieldIndex = Util.createMap(fieldName.length);
            int i = 0;
            while (i < fieldName.length) {
                fieldIndex.put(fieldName[i], new Integer(i));
                ++i;
            }
            return fieldIndex;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        protected int checkField(int fieldIndex) {
            if (fieldIndex < 0 || fieldIndex > this.getFieldCount() - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
            return fieldIndex;
        }

        public String getFieldName(int fieldIndex) {
            return this.fieldName[this.checkField(fieldIndex)];
        }

        public String getFieldTypeName(int fieldIndex) {
            return this.fieldTypeName[this.checkField(fieldIndex)];
        }

        public int getFieldIndex(String fieldName) {
            try {
                return (Integer)this.fieldIndex.get(fieldName);
            }
            catch (NullPointerException exc) {
                throw new IllegalArgumentException("Field with name '" + fieldName + "' doesn't exist.");
            }
        }
    }

    protected static class SubsetTupleMetaData
    extends TupleMetaData {
        protected TupleMetaData metaData;
        protected int startField;
        protected int fieldCount;

        public SubsetTupleMetaData(TupleMetaData metaData, int startField, int fieldCount) {
            if (metaData.getFieldCount() < fieldCount || metaData.getFieldCount() < startField + fieldCount - 1) {
                throw new IllegalArgumentException("Wrond field range.");
            }
            this.startField = startField;
            this.fieldCount = fieldCount;
            this.metaData = metaData;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        protected int checkField(int field) {
            if (field < 0 || field > this.fieldCount - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
            return this.startField + field;
        }

        public String getFieldName(int field) {
            return this.metaData.getFieldName(this.checkField(field));
        }

        public String getFieldTypeName(int field) {
            return this.metaData.getFieldTypeName(this.checkField(field));
        }

        public int getFieldIndex(String fieldName) {
            int fieldIndex = this.metaData.getFieldIndex(fieldName);
            if (fieldIndex < this.startField || fieldIndex > this.startField + this.fieldCount - 1) {
                throw new IllegalArgumentException("Field with name '" + fieldName + "' doesn't exist.");
            }
            return fieldIndex - this.startField;
        }
    }

    protected static class UnionTupleMetaData
    extends TupleMetaData {
        protected TupleMetaData metaData1;
        protected int fieldCount1;
        protected TupleMetaData metaData2;
        protected int fieldCount2;

        public UnionTupleMetaData(TupleMetaData metaData1, TupleMetaData metaData2) {
            this.metaData1 = metaData1;
            this.fieldCount1 = metaData1.getFieldCount();
            this.metaData2 = metaData2;
            this.fieldCount2 = metaData2.getFieldCount();
        }

        public int getFieldCount() {
            return this.fieldCount1 + this.fieldCount2;
        }

        public String getFieldName(int fieldIndex) {
            if (fieldIndex < this.fieldCount1) {
                return this.metaData1.getFieldName(fieldIndex);
            }
            return this.metaData2.getFieldName(fieldIndex - this.fieldCount1);
        }

        public String getFieldTypeName(int fieldIndex) {
            if (fieldIndex < this.fieldCount1) {
                return this.metaData1.getFieldTypeName(fieldIndex);
            }
            return this.metaData2.getFieldTypeName(fieldIndex - this.fieldCount1);
        }

        public int getFieldIndex(String fieldName) {
            try {
                return this.metaData1.getFieldIndex(fieldName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return this.metaData2.getFieldIndex(fieldName);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new IllegalArgumentException("Field with name '" + fieldName + "' doesn't exist.");
                }
            }
        }
    }
}

